<?php
session_start();
include '../config/database.php';

$step = 1;
$error = '';
$masked_phone = '';
$username = '';
$missing_indices = [3, 6, -1]; // 4th, 7th, last digit (0-based)
$expected_digits = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['username'])) {
        // Step 1: User submitted username
        $username = trim($_POST['username']);
        $stmt = $pdo->prepare('SELECT id, contact FROM lecturer_login WHERE username = ?');
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        if ($user && !empty($user['contact'])) {
            $phone = preg_replace('/\D/', '', $user['contact']); // Remove non-digits
            $masked_phone = $phone;
            foreach ($missing_indices as $i) {
                $idx = $i >= 0 ? $i : strlen($phone) + $i;
                if ($idx >= 0 && $idx < strlen($phone)) {
                    $expected_digits[] = $phone[$idx];
                    $masked_phone[$idx] = 'X';
                }
            }
            $_SESSION['reset_user_id'] = $user['id'];
            $_SESSION['reset_username'] = $username;
            $_SESSION['reset_phone'] = $phone;
            $_SESSION['reset_expected_digits'] = $expected_digits;
            $_SESSION['reset_masked_phone'] = $masked_phone;
            $step = 2;
        } else {
            $error = 'Username not found or no phone number on record.';
        }
    } elseif (isset($_POST['digit_0'], $_POST['digit_1'], $_POST['digit_2'])) {
        // Step 2: User submitted missing digits
        $expected_digits = $_SESSION['reset_expected_digits'] ?? [];
        $user_digits = [$_POST['digit_0'], $_POST['digit_1'], $_POST['digit_2']];
        if ($expected_digits && $user_digits === $expected_digits) {
            // Success: allow password reset
            $_SESSION['allow_password_reset'] = true;
            header('Location: reset_password.php');
            exit;
        } else {
            $error = 'Incorrect digits. Please try again.';
            $step = 2;
            $masked_phone = $_SESSION['reset_masked_phone'] ?? '';
        }
    }
} elseif (isset($_SESSION['reset_masked_phone'])) {
    $step = 2;
    $masked_phone = $_SESSION['reset_masked_phone'];
}

include 'lect_header.php';
?>

<div class="container d-flex justify-content-center align-items-center" style="min-height: 100vh;">
    <div class="card p-4" style="max-width: 400px; width: 100%;">
        <h2 class="card-title text-center">Forgot Password</h2>
        <?php if ($error): ?>
            <div class="alert alert-danger text-center"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <?php if ($step === 1): ?>
            <p class="text-muted text-center mb-4">Enter your username to reset your password using your phone number.</p>
            <form method="POST" action="">
                <div class="mb-3">
                    <label for="username" class="form-label">Username</label>
                    <input type="text" class="form-control" id="username" name="username" required>
                </div>
                <button type="submit" class="btn btn-primary w-100">Continue</button>
            </form>
        <?php elseif ($step === 2): ?>
            <p class="text-muted text-center mb-3">To verify your identity, enter the missing digits of your phone number:</p>
            <div class="mb-3 text-center">
                <span class="fw-bold" style="letter-spacing:2px; font-size:1.2rem;">
                    <?php echo htmlspecialchars($masked_phone); ?>
                </span>
            </div>
            <form method="POST" action="">
                <div class="row mb-3">
                    <div class="col">
                        <input type="text" maxlength="1" pattern="\d" class="form-control text-center" name="digit_0" placeholder="4th" required autofocus>
                    </div>
                    <div class="col">
                        <input type="text" maxlength="1" pattern="\d" class="form-control text-center" name="digit_1" placeholder="7th" required>
                    </div>
                    <div class="col">
                        <input type="text" maxlength="1" pattern="\d" class="form-control text-center" name="digit_2" placeholder="Last" required>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary w-100">Verify &amp; Reset</button>
            </form>
        <?php endif; ?>
        <div class="mt-3 text-center">
            <a href="login.php" class="small">Back to Login</a>
        </div>
    </div>
</div>

<?php include 'lect_footer.php'; ?>
