<?php
// flag_copies.php

// Include database connection
require '../config/database.php';

// Step 1: Fetch submitted internship reports and compute a report hash
$sql = "SELECT user_id, 
               MD5(CONCAT_WS('|', executive_summary, introduction, institution_profile, goals_objectives, core_duties, organizational_challenges, student_challenges, achievements, lessons_learned, recommendations, conclusion, references, appendix)) AS report_hash
        FROM internship_reports
        WHERE submission_date IS NOT NULL
          AND status = 'Submitted'";
$stmt = $pdo->query($sql);
$reports = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Step 2: Group reports by their hash to identify copies
$hashGroups = [];
foreach ($reports as $report) {
    $hash = $report['report_hash'];
    $hashGroups[$hash][] = $report['user_id'];
}

// Step 3: Identify flagged user IDs (reports with more than one occurrence)
$flaggedUserIds = [];
foreach ($hashGroups as $hash => $userIds) {
    if (count($userIds) > 1) {
        // If more than one student has the same report hash, flag them
        foreach ($userIds as $userId) {
            $flaggedUserIds[] = $userId;
        }
    }
}

// Remove any duplicate user IDs just in case
$flaggedUserIds = array_unique($flaggedUserIds);

// Step 4: If flagged user IDs exist, retrieve student details for display
$flaggedStudents = [];
if (!empty($flaggedUserIds)) {
    // Create a comma separated list for SQL IN clause
    $inClause = implode(',', array_map('intval', $flaggedUserIds));

    $sql = "SELECT user_id, first_name, surname, course FROM student_details WHERE user_id IN ($inClause)";
    $stmt = $pdo->query($sql);
    $flaggedStudents = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Flagged Report Copies</title>
    <!-- Include your CSS and Bootstrap if needed -->
</head>
<body>
<div class="container mt-4">
    <h2 class="text-center mb-4">Students Flagged for Report Copying</h2>

    <?php if (empty($flaggedStudents)): ?>
        <div class="alert alert-info">
            No potential report copies were flagged.
        </div>
    <?php else: ?>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>User ID</th>
                    <th>Student Name</th>
                    <th>Program</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($flaggedStudents as $student): ?>
                <tr>
                    <td><?php echo htmlspecialchars($student['user_id']); ?></td>
                    <td><?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?></td>
                    <td><?php echo htmlspecialchars($student['course']); ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
</body>
</html>
