<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['lecturer_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit;
}

require '../config/database.php';

// Get student ID from POST request
$student_id = intval($_POST['student_id'] ?? 0);

if (!$student_id) {
    echo json_encode(['success' => false, 'message' => 'Student ID is required']);
    exit;
}

try {
    // Fetch internship report details for the student
    $stmt = $pdo->prepare("
        SELECT 
            ir.start_date,
            ir.end_date,
            ir.department,
            ir.executive_summary,
            ir.introduction,
            ir.institution_profile,
            ir.goals_objectives,
            ir.core_duties,
            ir.organizational_challenges,
            ir.student_challenges,
            ir.achievements,
            ir.lessons_learned,
            ir.recommendations,
            ir.conclusion,
            ir.references,
            ir.appendix,
            ir.submission_date,
            ir.status,
            s.first_name,
            s.surname,
            s.course
        FROM internship_reports ir
        JOIN student_details s ON ir.user_id = s.user_id
        WHERE s.id = ?
    ");
    
    $stmt->execute([$student_id]);
    $report = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$report) {
        echo json_encode(['success' => false, 'message' => 'Report not found']);
        exit;
    }
    
    // Helper function to decrypt data
    function decryptData($data) {
        if (empty($data)) {
            return $data;
        }
        $cipher = 'AES-256-CBC';
        $iv_length = openssl_cipher_iv_length($cipher);
        $encryption_key = 'your-secret-key'; // Replace with your actual key

        $decoded = base64_decode($data, true);
        if ($decoded === false) {
            return $data;
        }
        if (strlen($decoded) <= $iv_length) {
            return $data;
        }
        $iv = substr($decoded, 0, $iv_length);
        $ciphertext = substr($decoded, $iv_length);
        $decrypted = openssl_decrypt($ciphertext, $cipher, $encryption_key, 0, $iv);
        return ($decrypted !== false) ? $decrypted : $data;
    }
    
    // Decrypt all report fields
    $decryptedReport = [];
    foreach ($report as $key => $value) {
        if ($key === 'id' || $key === 'user_id' || $key === 'submission_date' || $key === 'status') {
            $decryptedReport[$key] = $value;
        } else {
            $decryptedReport[$key] = decryptData($value);
        }
    }
    
    // Generate HTML content for the modal
    $html = '
    <div class="internship-report-details card shadow border-0 mb-3" style="background: #f4f8fd;">
        <div class="card-header" style="background: #1780f2; color: #fff; border-radius: 8px; padding: 18px 20px;">
            <div style="font-weight: bold;">Student Name: <span style="font-weight: normal;">' . htmlspecialchars($decryptedReport['first_name'] . ' ' . $decryptedReport['surname']) . '</span></div>
            <div style="font-weight: bold;">Program: <span style="font-weight: normal;">' . htmlspecialchars($decryptedReport['course']) . '</span></div>
            <div style="font-weight: bold;">Start Date: <span style="font-weight: normal;">' . htmlspecialchars($decryptedReport['start_date']) . '</span></div>
            <div style="font-weight: bold;">End Date: <span style="font-weight: normal;">' . htmlspecialchars($decryptedReport['end_date']) . '</span></div>
            <div style="font-weight: bold;">Department: <span style="font-weight: normal;">' . htmlspecialchars($decryptedReport['department']) . '</span></div>
            <div style="font-weight: bold;">Submission Date: <span style="font-weight: normal;">' . htmlspecialchars($decryptedReport['submission_date']) . '</span></div>
            <div style="font-weight: bold;">Status: <span style="font-weight: normal;">' . htmlspecialchars($decryptedReport['status']) . '</span></div>
        </div>
        <div class="card-body p-4">
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Executive Summary</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['executive_summary'])) . '</p>
            </div>
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Introduction</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['introduction'])) . '</p>
            </div>
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Institution Profile</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['institution_profile'])) . '</p>
            </div>
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Goals and Objectives</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['goals_objectives'])) . '</p>
            </div>
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Core Duties</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['core_duties'])) . '</p>
            </div>
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Organizational Challenges</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['organizational_challenges'])) . '</p>
            </div>
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Student Challenges</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['student_challenges'])) . '</p>
            </div>
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Achievements</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['achievements'])) . '</p>
            </div>
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Lessons Learned</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['lessons_learned'])) . '</p>
            </div>
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Recommendations</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['recommendations'])) . '</p>
            </div>
            <div class="report-section mb-4">
                <h5 class="fw-bold text-primary border-bottom pb-1">Conclusion</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['conclusion'])) . '</p>
            </div>
            <div class="report-section mb-2">
                <h5 class="fw-bold text-primary border-bottom pb-1">References</h5>
                <p class="ps-2">' . nl2br(htmlspecialchars($decryptedReport['references'])) . '</p>
            </div>
        </div>
    </div>';
    
    echo json_encode([
        'success' => true,
        'html' => $html,
        'student_id' => $student_id
    ]);
    
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?> 