<?php
// fetch_colleagues.php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['lecturer_id'])) {
    echo json_encode([]);
    exit;
}

require '../config/database.php';

$studentId = $_GET['student_id'] ?? null;
$currentLecturerId = $_SESSION['lecturer_id'];

if (!$studentId) {
    echo json_encode([]);
    exit;
}

// Get the student's region from student_details
$stmt = $pdo->prepare("SELECT region FROM student_details WHERE id = ?");
$stmt->execute([$studentId]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$student) {
    echo json_encode([]);
    exit;
}
$studentRegion = $student['region'];

// Fetch lecturers whose preferred_region matches the student's region and exclude the current lecturer
$stmt = $pdo->prepare("
    SELECT l.id, l.name
    FROM lecturer_login l
    JOIN lecturer_preferences p ON l.id = p.lecturer_id
    WHERE p.preferred_region = ?
      AND l.id != ?
");
$stmt->execute([$studentRegion, $currentLecturerId]);
$colleagues = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo json_encode($colleagues);
exit;
?>
