<?php
require '../config/database.php';
require '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Only accept POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die('Invalid request method.');
}

$lecturerId = $_POST['lecturer_id'] ?? '';
$region     = $_POST['region']       ?? '';

if (empty($lecturerId)) {
    die("Lecturer not selected.");
}

// Fetch lecturer name
$lectStmt = $pdo->prepare("SELECT name FROM lecturer_login WHERE id = ?");
$lectStmt->execute([$lecturerId]);
$lecturer = $lectStmt->fetchColumn() ?: 'Unknown Lecturer';

// 1) Fetch student data
$sql = "
    SELECT 
        u.index_number AS student_id,
        sd.first_name,
        sd.surname,
        sd.organisation_name,
        sd.location,
        sd.telephone,
        lad.region,
        lad.district
    FROM student_details sd
    JOIN users u 
      ON sd.user_id = u.id
    JOIN lecturer_assigned_districts lad 
      ON sd.lecturer_id = lad.lecturer_id 
     AND sd.district = lad.district
    WHERE sd.lecturer_id = :lecturer_id
      AND sd.status = 'submitted'
" . (!empty($region) ? " AND lad.region = :region" : "");

$params = [':lecturer_id' => $lecturerId];
if (!empty($region)) {
    $params[':region'] = $region;
}

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($students)) {
    die("No students found for export.");
}

// 2) Create Spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// 3) Lecturer name in A1
$sheet->setCellValue('A1', "Lecturer: {$lecturer}");
$sheet->getStyle('A1')->getFont()->setBold(true);

// 4) Header row on row 2
$headers = ['Student ID', 'Full Name', 'Organisation', 'Location', 'Telephone', 'Region', 'District'];
$col = 'A';
foreach ($headers as $header) {
    $sheet->setCellValue("{$col}2", $header);
    $sheet->getStyle("{$col}2")->getFont()->setBold(true);
    $col++;
}

// 5) Data rows starting at row 3
$rowNum = 3;
foreach ($students as $row) {
    $fullName = ucwords(strtolower($row['first_name'] . ' ' . $row['surname']));
    $sheet->setCellValue("A{$rowNum}", $row['student_id']);
    $sheet->setCellValue("B{$rowNum}", $fullName);
    $sheet->setCellValue("C{$rowNum}", $row['organisation_name']);
    $sheet->setCellValue("D{$rowNum}", $row['location']);
    $sheet->setCellValue("E{$rowNum}", $row['telephone']);
    $sheet->setCellValue("F{$rowNum}", $row['region']);
    $sheet->setCellValue("G{$rowNum}", $row['district']);
    $rowNum++;
}

// 6) Auto-size columns A–G
foreach (range('A','G') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

// 7) Output to browser
$filename = 'filtered_students.xlsx';
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment;filename=\"{$filename}\"");
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
