<?php
session_start();
if (!isset($_SESSION['lecturer_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php';

$lecturerId = $_SESSION['lecturer_id'];

// Fetch lecturer's name
$stmt = $pdo->prepare('SELECT name FROM lecturer_login WHERE id = ?');
$stmt->execute([$lecturerId]);
$lecturer = $stmt->fetch();
$lecturerName = $lecturer ? htmlspecialchars($lecturer['name'], ENT_QUOTES, 'UTF-8') : '';

// Fetch assigned students' details
$stmt = $pdo->prepare('
    SELECT sd.first_name, sd.surname, u.index_number, sd.telephone, sd.organisation_name, sd.location, sd.district, sd.region, sd.gps_location 
    FROM student_details sd 
    JOIN users u ON sd.user_id = u.id
    WHERE sd.lecturer_id = ?
');
$stmt->execute([$lecturerId]);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Set headers to force download as a Word document
header("Content-type: application/vnd.ms-word");
header("Content-Disposition: attachment;Filename=AssignedStudents_{$lecturerName}.doc");
?>
<html>
<head>
<meta charset="utf-8">
<title>Students assigned to <?php echo $lecturerName; ?></title>
<style>
    table { border-collapse: collapse; width: 100%; }
    table, th, td { border: 1px solid black; }
    th, td { padding: 5px; text-align: left; }
</style>
</head>
<body>
    <h2>Students assigned to <?php echo $lecturerName; ?></h2>
    <table>
        <thead>
            <tr>
                <th>No.</th>
                <th>Name (Index Number)</th>
                <th>Telephone Number</th>
                <th>Organisation (Location)</th>
                <th>District/Region</th>
                <th>GPS Location</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($students as $index => $student): ?>
            <tr>
                <td><?php echo $index + 1; ?></td>
                <td>
                    <?php 
                        $fullName = htmlspecialchars($student['first_name'] . ' ' . $student['surname'], ENT_QUOTES, 'UTF-8');
                        $indexNumber = htmlspecialchars($student['index_number'], ENT_QUOTES, 'UTF-8');
                        echo $fullName . " (" . $indexNumber . ")";
                    ?>
                </td>
                <td><?php echo htmlspecialchars($student['telephone'], ENT_QUOTES, 'UTF-8'); ?></td>
                <td>
                    <?php 
                        $org = htmlspecialchars($student['organisation_name'], ENT_QUOTES, 'UTF-8');
                        $loc = htmlspecialchars($student['location'], ENT_QUOTES, 'UTF-8');
                        echo $org . " (" . $loc . ")";
                    ?>
                </td>
                <td><?php echo htmlspecialchars($student['district'] . '/' . substr($student['region'], 0, 2), ENT_QUOTES, 'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars($student['gps_location'], ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
