<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require '../config/database.php'; // Include database connection

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    
    // Fetch Group Details
    try {
        $sql = "SELECT * FROM pi_lecturer_groups WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $group = $stmt->fetch();
    } catch (PDOException $e) {
        echo "<div class='alert alert-danger'>Error fetching group: " . $e->getMessage() . "</div>";
    }
    
    // Handle Form Submission
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $new_name = trim($_POST['group_name']);
        $new_category = $_POST['category'] ?? 'Industrial Internship';
        
        if (!empty($new_name)) {
            try {
                $sql = "UPDATE pi_lecturer_groups SET group_name = :group_name, category = :category WHERE id = :id";
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':group_name', $new_name);
                $stmt->bindParam(':category', $new_category);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $stmt->execute();
                echo "<div class='alert alert-success'>Group updated successfully!</div>";
            } catch (PDOException $e) {
                echo "<div class='alert alert-danger'>Database Error: " . $e->getMessage() . "</div>";
            }
        } else {
            echo "<div class='alert alert-warning'>Group name cannot be empty!</div>";
        }
    }
}

include('pi_header.php');
?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <!-- Adjust col-md-6 (or col-md-4) to reduce the card width -->
        <div class="col-md-6">
            <div class="card shadow-lg p-4">
                <h2 class="mb-4">Edit Lecturer Group</h2>
                <form method="post">
                    <div class="mb-3">
                        <label for="group_name" class="form-label">Group Name</label>
                        <input type="text" name="group_name" id="group_name" class="form-control" value="<?php echo htmlspecialchars($group['group_name']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="category" class="form-label">Category</label>
                        <select name="category" id="category" class="form-select">
                            <option value="Industrial Internship" <?php echo ($group['category'] === 'Industrial Internship') ? 'selected' : ''; ?>>Industrial Internship</option>
                            <option value="Teaching Practice" <?php echo ($group['category'] === 'Teaching Practice') ? 'selected' : ''; ?>>Teaching Practice</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Update Group</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('pi_footer.php'); ?>
