<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}

include '../config/database.php';

// Fetch all acceptance letters from the database
$stmt = $pdo->prepare('SELECT acceptance_letter FROM student_details WHERE acceptance_letter IS NOT NULL');
$stmt->execute();
$letters = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($letters)) {
    echo "No acceptance letters found.";
    exit;
}

$zip = new ZipArchive();
$zipFileName = 'acceptance_letters.zip';
$zipFilePath = sys_get_temp_dir() . '/' . $zipFileName;

if ($zip->open($zipFilePath, ZipArchive::CREATE) !== TRUE) {
    exit("Unable to create zip file.");
}

// Add files to the zip
foreach ($letters as $letter) {
    $filePath = '../uploads/' . $letter['acceptance_letter'];
    if (file_exists($filePath)) {
        $zip->addFile($filePath, basename($filePath));
    }
}

$zip->close();

header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $zipFileName . '"');
header('Content-Length: ' . filesize($zipFilePath));

readfile($zipFilePath);
unlink($zipFilePath); // Delete the temp file
exit;
?>
