<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require '../config/database.php'; // Include your database connection here

// We'll store alert messages in variables
$msg = "";
$msg_type = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $group_name = trim($_POST['group_name']);

    if (!empty($group_name)) {
        try {
            $sql = "INSERT INTO pi_lecturer_groups (group_name) VALUES (:group_name)";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':group_name', $group_name);
            $stmt->execute();

            // Success alert
            $msg = "Group created successfully!";
            $msg_type = "success";
        } catch (PDOException $e) {
            // Database error alert
            $msg = "Database Error: " . $e->getMessage();
            $msg_type = "danger";
        }
    } else {
        // Validation error alert
        $msg = "Error: Group name cannot be empty!";
        $msg_type = "warning";
    }
}

include('pi_header.php');
?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <!-- Adjust the column width (e.g., col-md-6 or col-md-4) to reduce card size -->
        <div class="col-md-6">

            <!-- Alert message (only shown if $msg is not empty) -->
            <?php if(!empty($msg)): ?>
                <div 
                  id="alert-message" 
                  class="alert alert-<?php echo $msg_type; ?> alert-dismissible fade show" 
                  role="alert"
                >
                    <?php echo $msg; ?>
                </div>
            <?php endif; ?>

            <div class="card shadow-lg p-4">
                <h2 class="mb-4">Create a Lecturer Group</h2>
                <form method="post">
                    <div class="mb-3">
                        <label for="group_name" class="form-label">Group Name</label>
                        <input 
                          type="text" 
                          name="group_name" 
                          id="group_name" 
                          class="form-control" 
                          placeholder="Enter Group Name" 
                          required
                        >
                    </div>
                    <button type="submit" class="btn btn-primary">Create Group</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript to auto-hide the alert after 3 seconds -->
<script>
    setTimeout(function() {
        let alertEl = document.getElementById('alert-message');
        if (alertEl) {
            // Option 1: Simply remove the alert from the DOM
            alertEl.remove();

            // Option 2: Fade out before removing 
            // alertEl.classList.add('fade'); 
            // setTimeout(() => alertEl.remove(), 500);
        }
    }, 3000);
</script>

<?php include('pi_footer.php'); ?>
