<?php
// File: colleague_lecturers.php
session_start();
require '../config/database.php'; // Adjust path as needed

// Retrieve current lecturer ID from session
$currentLecturerId = $_SESSION['lecturer_id'] ?? null;
if (!$currentLecturerId) {
    die("Access denied. Please log in as a lecturer.");
}

// Retrieve the group_id for the current lecturer from lecturer_login table
$stmt = $pdo->prepare("SELECT group_id FROM lecturer_login WHERE id = ?");
$stmt->execute([$currentLecturerId]);
$currentLecturer = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$currentLecturer || empty($currentLecturer['group_id'])) {
    die("Group information not found for the current lecturer.");
}

$currentGroupId = $currentLecturer['group_id'];

// Fetch all lecturers in the same group excluding the current lecturer
$stmt = $pdo->prepare("
    SELECT id, name 
    FROM lecturer_login 
    WHERE group_id = ? 
      AND id != ?
");
$stmt->execute([$currentGroupId, $currentLecturerId]);
$colleagues = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch current lecturer's name
$stmt = $pdo->prepare("SELECT name FROM lecturer_login WHERE id = ?");
$stmt->execute([$currentLecturerId]);
$currentLecturerName = $stmt->fetchColumn();

// Fetch group name
$stmt = $pdo->prepare("SELECT group_name FROM pi_lecturer_groups WHERE id = ?");
$stmt->execute([$currentGroupId]);
$groupName = $stmt->fetchColumn();
?>

<!-- Modal Body Only: List of Colleague Lecturers -->
<div class="modal-body">
  <h6 class="text-muted mb-3"><?php echo htmlspecialchars($groupName, ENT_QUOTES, 'UTF-8'); ?></h6>
  <ul class="list-group">
    <li class="list-group-item">
      <?php echo htmlspecialchars($currentLecturerName, ENT_QUOTES, 'UTF-8'); ?>
    </li>
    <?php if (count($colleagues) > 0): ?>
      <?php foreach ($colleagues as $colleague): ?>
        <li class="list-group-item">
          <?php echo htmlspecialchars($colleague['name'], ENT_QUOTES, 'UTF-8'); ?>
        </li>
      <?php endforeach; ?>
    <?php else: ?>
      <li class="list-group-item text-muted">No colleague lecturers found in your group.</li>
    <?php endif; ?>
  </ul>
</div>
