<?php
session_start();
require '../config/database.php';

// Check if lecturer is logged in
if (!isset($_SESSION['lecturer_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Not authenticated.']);
    exit;
}

// Get student ID from POST data
$student_id = $_POST['student_id'] ?? null;
$lecturer_id = $_SESSION['lecturer_id'];

if (!$student_id) {
    echo json_encode(['status' => 'error', 'message' => 'Student ID is required.']);
    exit;
}

try {
    // Check if lecturer has already graded this student's report
    $stmt = $pdo->prepare("
        SELECT report_score, report_comments 
        FROM pi_student_grades 
        WHERE student_id = ? AND lecturer_id = ? AND report_score IS NOT NULL
        ORDER BY graded_at DESC 
        LIMIT 1
    ");
    $stmt->execute([$student_id, $lecturer_id]);
    $grade = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($grade) {
        echo json_encode([
            'status' => 'success',
            'report_score' => $grade['report_score'],
            'report_comments' => $grade['report_comments']
        ]);
    } else {
        echo json_encode([
            'status' => 'success',
            'report_score' => null,
            'report_comments' => null
        ]);
    }
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}
?> 