<?php
session_start();
require '../config/database.php';

// Check if lecturer is logged in
if (!isset($_SESSION['lecturer_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated.']);
    exit;
}

// Get student ID from POST data
$student_id = $_POST['student_id'] ?? null;
$lecturer_id = $_SESSION['lecturer_id'];

if (!$student_id) {
    echo json_encode(['success' => false, 'message' => 'Student ID is required.']);
    exit;
}

try {
    // First, check if this is a teaching internship student
    $stmtCheckType = $pdo->prepare("
        SELECT u.group AS user_group 
        FROM student_details s 
        JOIN users u ON s.user_id = u.id 
        WHERE s.id = ?
    ");
    $stmtCheckType->execute([$student_id]);
    $studentType = $stmtCheckType->fetch(PDO::FETCH_ASSOC);
    
    if ($studentType && $studentType['user_group'] === 'Teaching Practice') {
        // Check teaching grading status
        $stmtTeaching = $pdo->prepare("
            SELECT total_score 
            FROM teaching_grades 
            WHERE student_id = ? AND lecturer_id = ? 
            ORDER BY graded_at DESC 
            LIMIT 1
        ");
        $stmtTeaching->execute([$student_id, $lecturer_id]);
        $teachingGrade = $stmtTeaching->fetch(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'grading_type' => 'teaching',
            'has_grade' => $teachingGrade && $teachingGrade['total_score'] !== null,
            'total_score' => $teachingGrade ? $teachingGrade['total_score'] : null
        ]);
    } else {
        // Check regular internship grading status
        $stmtRegular = $pdo->prepare("
            SELECT report_score, presentation_score, grading_type
            FROM pi_student_grades 
            WHERE student_id = ? AND lecturer_id = ? 
            ORDER BY graded_at DESC 
            LIMIT 1
        ");
        $stmtRegular->execute([$student_id, $lecturer_id]);
        $regularGrade = $stmtRegular->fetch(PDO::FETCH_ASSOC);
        
        $hasReportGrade = $regularGrade && $regularGrade['report_score'] !== null;
        $hasPresentationGrade = $regularGrade && $regularGrade['presentation_score'] !== null;
        
        echo json_encode([
            'success' => true,
            'grading_type' => 'regular',
            'has_report_grade' => $hasReportGrade,
            'has_presentation_grade' => $hasPresentationGrade,
            'report_score' => $regularGrade ? $regularGrade['report_score'] : null,
            'presentation_score' => $regularGrade ? $regularGrade['presentation_score'] : null,
            'grading_type_db' => $regularGrade ? $regularGrade['grading_type'] : null
        ]);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?> 