<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require '../config/database.php';

// Fetch all groups
try {
    $stmt = $pdo->query("SELECT * FROM pi_lecturer_groups ORDER BY group_name ASC");
    $groups = $stmt->fetchAll();
} catch (PDOException $e) {
    die("Error fetching groups: " . $e->getMessage());
}

// Fetch all lecturers (who are not yet assigned to a group)
try {
    $stmt = $pdo->query("SELECT id, name FROM lecturer_login WHERE group_id IS NULL ORDER BY name ASC");
    $lecturers = $stmt->fetchAll();
} catch (PDOException $e) {
    die("Error fetching lecturers: " . $e->getMessage());
}

// Fetch current lecturer allocations
try {
    $stmt = $pdo->query("
        SELECT l.id AS lecturer_id, l.name AS lecturer_name, g.id AS group_id, g.group_name
        FROM lecturer_login l
        JOIN pi_lecturer_groups g ON l.group_id = g.id
        ORDER BY g.group_name ASC
    ");
    $allocations = $stmt->fetchAll();
} catch (PDOException $e) {
    die("Error fetching allocations: " . $e->getMessage());
}

// Handle lecturer assignment
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['assign'])) {
    $lecturer_id = $_POST['lecturer_id'];
    $group_id = $_POST['group_id'];

    if (!empty($lecturer_id) && !empty($group_id)) {
        try {
            $stmt = $pdo->prepare("UPDATE lecturer_login SET group_id = :group_id WHERE id = :lecturer_id");
            $stmt->execute(['group_id' => $group_id, 'lecturer_id' => $lecturer_id]);
            echo "<div class='alert alert-success'>Lecturer assigned successfully!</div>";
            header("Refresh:0"); // Refresh page to update allocations
        } catch (PDOException $e) {
            echo "<div class='alert alert-danger'>Error: " . $e->getMessage() . "</div>";
        }
    } else {
        echo "<div class='alert alert-warning'>Please select both a lecturer and a group.</div>";
    }
}

// Handle lecturer deallocation (Delete function)
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['delete'])) {
    $lecturer_id = $_POST['lecturer_id'];

    if (!empty($lecturer_id)) {
        try {
            $stmt = $pdo->prepare("UPDATE lecturer_login SET group_id = NULL WHERE id = :lecturer_id");
            $stmt->execute(['lecturer_id' => $lecturer_id]);
            echo "<div class='alert alert-success'>Lecturer removed from group!</div>";
            header("Refresh:0"); // Refresh page to update allocations
        } catch (PDOException $e) {
            echo "<div class='alert alert-danger'>Error: " . $e->getMessage() . "</div>";
        }
    }
}

include('pi_header.php'); // Include the header
?>

<div class="container mt-4">
    <div class="d-flex justify-content-center">
        <div class="col-md-6">
            <div class="card shadow-sm p-3">
                <h4 class="text-center mb-3">Assign Lecturer to a Group</h4>
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">Select Lecturer</label>
                        <select name="lecturer_id" class="form-control form-control-sm" required>
                            <option value="">-- Select Lecturer --</option>
                            <?php foreach ($lecturers as $lecturer) : ?>
                                <option value="<?php echo $lecturer['id']; ?>">
                                    <?php echo htmlspecialchars($lecturer['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Select Group</label>
                        <select name="group_id" class="form-control form-control-sm" required>
                            <option value="">-- Select Group --</option>
                            <?php foreach ($groups as $group) : ?>
                                <option value="<?php echo $group['id']; ?>">
                                    <?php echo htmlspecialchars($group['group_name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <button type="submit" name="assign" class="btn btn-primary btn-sm w-100">Assign Lecturer</button>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-12 mt-4">
        <h4>Current Lecturer Allocations</h4>
        <table class="table table-striped table-sm">
            <thead>
                <tr>
                    <th>Group Name</th>
                    <th>Lecturer</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($allocations) > 0): ?>
                    <?php foreach ($allocations as $allocation): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($allocation['group_name']); ?></td>
                            <td><?php echo htmlspecialchars($allocation['lecturer_name']); ?></td>
                            <td>
                                <form method="post" style="display:inline;">
                                    <input type="hidden" name="lecturer_id" value="<?php echo $allocation['lecturer_id']; ?>">
                                    <button type="submit" name="delete" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to remove this lecturer?');">Remove</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3" class="text-center">No lecturers assigned yet.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include('pi_footer.php'); // Include the footer ?>
