<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Define the logs directory path
define('LOGS_DIR', __DIR__ . '/../logs');

// Ensure logs directory exists and is writable
if (!is_dir(LOGS_DIR)) {
    if (!mkdir(LOGS_DIR, 0755, true)) {
        die("Failed to create logs directory at: " . LOGS_DIR);
    }
}

// Test if we can write to the logs directory
$testFile = LOGS_DIR . '/test.log';
if (!@file_put_contents($testFile, 'test')) {
    die("Cannot write to logs directory. Please check permissions for: " . LOGS_DIR);
}
@unlink($testFile); // Clean up test file

function handleError($errno, $errstr, $errfile, $errline) {
    $error_message = date('Y-m-d H:i:s') . " - Error [$errno]: $errstr in $errfile on line $errline\n";
    
    // Log to both custom log and PHP's default error log
    error_log($error_message, 3, LOGS_DIR . '/error.log');
    error_log($error_message);
    
    // Show detailed error in development
    if (ini_get('display_errors')) {
        echo "<div class='alert alert-danger'>";
        echo "<strong>Error Details:</strong><br>";
        echo "Type: " . $errno . "<br>";
        echo "Message: " . htmlspecialchars($errstr) . "<br>";
        echo "File: " . htmlspecialchars($errfile) . "<br>";
        echo "Line: " . $errline;
        echo "</div>";
    }
    
    return true;
}

function handleException($exception) {
    $error_message = date('Y-m-d H:i:s') . " - Exception: " . $exception->getMessage() . 
                    " in " . $exception->getFile() . " on line " . $exception->getLine() . "\n";
    
    // Log to both custom log and PHP's default error log
    error_log($error_message, 3, LOGS_DIR . '/error.log');
    error_log($error_message);
    
    // Show detailed error in development
    if (ini_get('display_errors')) {
        echo "<div class='alert alert-danger'>";
        echo "<strong>Exception Details:</strong><br>";
        echo "Message: " . htmlspecialchars($exception->getMessage()) . "<br>";
        echo "File: " . htmlspecialchars($exception->getFile()) . "<br>";
        echo "Line: " . $exception->getLine();
        echo "</div>";
    }
}

// Set error and exception handlers
set_error_handler('handleError');
set_exception_handler('handleException'); 