<?php
$isLoggedIn = isset($_SESSION['user_id']);
$role = isset($_SESSION['role']) ? $_SESSION['role'] : 'student';
$indexNumber = isset($_SESSION['index_number']) ? $_SESSION['index_number'] : '';
?>

<nav class="navbar navbar-expand-lg navbar-light" style="background-color: #163485;">
    <div class="container-fluid">
        <a class="navbar-brand" href="../public/index.php">
            <img src="../public/img/sob_logo.png" alt="Logo" width="30" height="30" class="d-inline-block align-top">
            <span class="brand-text d-none d-lg-inline" style="color: white;">UEW School of Business Internship</span>
            <span class="brand-text d-lg-none" style="color: white;">UEW SOB-Intern</span>
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <?php if ($isLoggedIn): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="../public/dashboard.php" style="color: white;">
                            <i class="fas fa-tachometer-alt"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="../public/view_submission.php" style="color: white;">
                            <i class="fas fa-file-alt"></i> View Submission
                        </a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="transferDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false" style="color: white;">
                            <i class="fas fa-exchange-alt"></i> Transfer
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="transferDropdown">
                            <?php if ($role == 'student'): ?>
                                <li><a class="dropdown-item" href="../public/transfer_request.php">Request Transfer</a></li>
                                <li><a class="dropdown-item" href="../public/transfer_status.php">Transfer Status</a></li>
                            <?php endif; ?>
                            <?php if ($role == 'coordinator'): ?>
                                <li><a class="dropdown-item" href="../public/transfer_approvals.php">Approvals</a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <?php if ($role == 'coordinator'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="../public/coordinator_dashboard.php" style="color: white;">
                                <i class="fas fa-chalkboard-teacher"></i> Coordinator Dashboard
                            </a>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false" style="color: white;">
                            <i class="fas fa-user"></i> <?php echo htmlspecialchars($indexNumber); ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                            <li><a class="dropdown-item" href="../public/change_password.php"><i class="fas fa-key"></i> Change Password</a></li>
                            <li><a class="dropdown-item" href="../public/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
                        </ul>
                    </li>
                <?php else: ?>
                    <li class="nav-item d-none d-lg-block">
                        <form class="d-flex" method="POST" action="../public/login_action.php">
                            <input class="form-control me-2" type="text" placeholder="Index Number" name="indexNumber" required>
                            <input class="form-control me-2" type="password" placeholder="Password" name="password" required>
                            <button class="btn btn-outline-light" type="submit">Login</button>
                        </form>
                    </li>
                    <li class="nav-item d-lg-none">
                        <a class="nav-link" href="../public/login.php" style="color: white;">
                            Login
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>

<!-- Include FontAwesome for icons -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/js/all.min.js"></script>
