<?php include 'header.php'; ?>

<div class="container mt-5">
    <div class="whatsapp-contact text-center mb-4">
        <a href="https://wa.me/233274340033" target="_blank" class="btn btn-success" style="display: inline-flex; align-items: center; text-decoration: none;">
            <img src="whatsapp.png" alt="WhatsApp" style="width: 24px; height: 24px; margin-right: 8px;">
            Contact Support on WhatsApp
        </a>
    </div>

    <div class="card shadow-lg p-4">
        <h2 class="text-center mb-4">Submitting a Transfer Request</h2>
        <p class="text-center mb-4">If you need to transfer to a new organization or school during your internship, please follow these steps to submit a transfer request:</p>

        <ol class="list-group list-group-numbered">
            <li class="list-group-item">
                <strong>Access the Transfer Request Page:</strong>
                <ul class="list-unstyled ms-3">
                    <li><strong>Login:</strong> Ensure you are logged into your account.</li>
                    <li><strong>Navigate:</strong> Go to the <a href="../transfer_request.php" class="text-primary">Transfer Request Page</a>.</li>
                </ul>
            </li>

            <li class="list-group-item">
                <strong>Check Current Internship Details:</strong>
                <ul class="list-unstyled ms-3">
                    <li>Your current organization or school details will be displayed if available.</li>
                </ul>
            </li>

            <li class="list-group-item">
                <strong>Fill in the Transfer Request Form:</strong>
                <ul class="list-unstyled ms-3">
                    <li><strong>New Organisation Name:</strong> Enter the name of your new organization or school.</li>
                    <li><strong>New Location:</strong> Enter the new location.</li>
                    <li><strong>New Ghana Post GPS/Google Location:</strong> Provide the GPS or Google location.</li>
                    <li><strong>New Region:</strong> Select the new region from the dropdown menu.</li>
                    <li><strong>New District:</strong> Select the new district (populated based on the selected region).</li>
                    <li><strong>Reason for Transfer:</strong> Provide a reason for your transfer.</li>
                    <li><strong>Upload Acceptance Letter:</strong> Click the "Choose File" button and select the acceptance letter from your new organization or school.</li>
                </ul>
            </li>

            <li class="list-group-item">
                <strong>Submit Your Transfer Request:</strong>
                <ul class="list-unstyled ms-3">
                    <li>Click the "Submit Transfer Request" button to submit your form.</li>
                </ul>
            </li>
        </ol>

        <h3 class="mt-4">Status Messages</h3>
        <ul class="list-unstyled ms-3">
            <li>You will receive status messages on the page based on your actions:</li>
            <li><strong>Transfer Request Submitted:</strong> Your transfer request has been submitted and is pending approval.</li>
        </ul>

        <h3 class="mt-4">View Approved Transfers</h3>
        <ul class="list-unstyled ms-3">
            <li>If your transfer request is approved, you will see the details of your former and current organizations.</li>
        </ul>

        <h3 class="mt-4">If You Encounter Issues</h3>
        <ul class="list-unstyled ms-3">
            <li>Ensure all fields are correctly filled before submitting.</li>
            <li>For further assistance, contact the help desk:</li>
            <li><strong>Email:</strong> <a href="mailto:help@uew-sob.com" class="text-primary">help@uew-sob.com</a></li>
            <li><strong>Phone:</strong>
                <div class="d-block">
                    024 365 8609 <br>
                    026 881 8765 <br>
                    024 078 1947
                </div>
            </li>
        </ul>
    </div>
</div>

<?php include 'footer.php'; ?>
