<?php include 'header.php'; ?>

<div class="container mt-5">
    <div class="whatsapp-contact text-center mb-4">
        <a href="https://wa.me/233274340033" target="_blank" class="btn btn-success" style="display: inline-flex; align-items: center; text-decoration: none;">
            <img src="whatsapp.png" alt="WhatsApp" style="width: 24px; height: 24px; margin-right: 8px;">
            Contact Support on WhatsApp
        </a>
    </div>

    <div class="card shadow-lg p-4">
        <h2 class="text-center mb-4">Registration Guide</h2>
        <p class="text-center mb-4">Welcome to the University of Education, Winneba - School of Business Internship Portal! Follow the steps below to complete your registration:</p>

        <ol class="list-group list-group-numbered">
            <li class="list-group-item">
                <strong>Go to the Registration Page:</strong> 
                Visit the <a href="../student/register" class="text-primary">Registration Page</a>.
            </li>

            <li class="list-group-item">
                <strong>Fill in Your Details:</strong>
                <ul class="list-unstyled ms-3">
                    <li><strong>Index Number:</strong> Enter your index number.</li>
                    <li><strong>Password:</strong> Enter and confirm your password.</li>
                    <li><strong>Internship Group:</strong> Select your group (Industrial Internship or Teaching Practice).</li>
                    <li><strong>Security Question:</strong> Choose a question and provide an answer.</li>
                </ul>
            </li>

            <li class="list-group-item">
                <strong>Submit Your Registration:</strong>
                <ul class="list-unstyled ms-3">
                    <li>Click the "Register" button.</li>
                    <li>If you see an error message:
                        <ul>
                            <li><strong>"Index number cannot be found":</strong> Your index number is not in the database. If you are a Level 300 student, contact the help desk.</li>
                            <li><strong>"Passwords do not match":</strong> Ensure both password fields match.</li>
                            <li><strong>"Index number already exists":</strong> You have already registered.</li>
                        </ul>
                    </li>
                </ul>
            </li>

            <li class="list-group-item">
                <strong>Help Desk Contact:</strong>
                <ul class="list-unstyled ms-3">
                    <li>If you are a Level 300 student and your index number is not in the database, please contact the help desk:</li>
                    <li><strong>Email:</strong> <a href="mailto:help@uew-sob.com" class="text-primary">help@uew-sob.com</a></li>
                    <li><strong>Phone:</strong>
                        <div class="d-block">
                            024 365 8609 <br>
                            026 881 8765 <br>
                            024 078 1947
                        </div>
                    </li>
                </ul>
            </li>
        </ol>
    </div>
</div>

<?php include 'footer.php'; ?>
