# SOB-IMS — Project Index

Quick reference for the **Internship Management System** codebase. See **docs/PROJECT_OVERVIEW.md** for domain and scope; **docs/STUDENT_MODULE_AND_START.md** for Phase 1 (new student module) guidance.

---

## 1. Project at a Glance

| Item | Value |
|------|--------|
| **Name** | SOB-IMS (School of Business – Internship Management System) |
| **Stack** | PHP (procedural), MySQL (`internship_portal`), Composer |
| **Entry** | `index.php` — path-based routing with base `/ims/` |
| **Auth** | Session-based: `user_id`, `admin_id`, `sys_admin_id`, `role` |

---

## 2. Root Structure

```
ims/
├── index.php          # Single entry point; routes by path
├── welcome.php        # Landing page (redirect when path is empty)
├── config/
│   └── database.php   # PDO connection (MySQL)
├── includes/          # Shared headers, nav, footer, functions, error handler
├── help/              # Public help site (login, registration, index)
├── student/           # Student module (dashboard, details, transfers, reports)
├── lecturer/          # Lecturer module (mapping, grading, exports, SMS)
├── admin/             # Admin module (assignments, transfers, results)
├── sys_admin/         # System admin (accounts, audit, reset) — not in index.php routes
├── errors/            # 404 and error pages
├── public/            # Static assets
├── uploads/           # User uploads (letters, reports, etc.)
├── vendor/            # Composer dependencies
├── db_gateway.php     # DB access helper
├── composer.json      # PHP dependencies
└── docs/              # PROJECT_OVERVIEW.md, STUDENT_MODULE_AND_START.md, this file
```

---

## 3. Routing (index.php)

- **Base path:** `/ims/`
- **Public (no login):** `welcome`, `student/register`, `student/login`, `student/login_action`, `lecturer/login`, `lecturer/signup`, `lecturer/signup_action`, `help/index`, `help/login`
- **Protected:** All other paths require `$_SESSION['user_id']` (or role check for admin)
- **Admin:** Paths under `admin/*` require `$_SESSION['role'] === 'admin'`

### 3.1 Student routes (in index.php)

| Path | File |
|------|------|
| `student`, `student/` | `student/index.php` |
| `student/dashboard` | `student/dashboard.php` |
| `student/register` | `student/register.php` |
| `student/login` | `student/login.php` |
| `student/login_action` | `student/login_action.php` |
| `student/save_student_details` | `student/save_student_details.php` |
| `student/fetch_districts` | `student/fetch_districts.php` |
| `student/download_evaluation` | `student/download_evaluation.php` |
| `student/view_submission` | `student/view_submission.php` |
| `student/transfer_request` | `student/transfer_request.php` |
| `student/transfer_status` | `student/transfer_status.php` |
| `student/change_password` | `student/change_password.php` |
| `student/logout` | `student/logout.php` |
| `student/download_submission` | `student/download_submission.php` |

**Note:** Some student scripts exist but are not in the router (e.g. `forgot_password.php`, `reset_password.php`, `register_action.php`, `submit_letter.php`, `submit_letter_action.php`, `submit_teaching_report.php`, `teaching_report.php`, `upload_photos.php`). They may be included by other pages or reached via form actions.

### 3.2 Lecturer routes (in index.php)

| Path | File |
|------|------|
| `lecturer`, `lecturer/` | `lecturer/index.php` |
| `lecturer/login` | `lecturer/login.php` |
| `lecturer/signup`, `lecturer/signup_action` | `lecturer/signup.php`, `lecturer/signup_action.php` |
| `lecturer/logout` | `lecturer/logout.php` |
| `lecturer/mapping` | `lecturer/mapping.php` |
| `lecturer/region` | `lecturer/region.php` |
| `lecturer/save_mapping`, `lecturer/submit_mapping` | `lecturer/save_mapping.php`, `lecturer/submit_mapping.php` |
| `lecturer/send_sms` | `lecturer/send_sms.php` |
| `lecturer/edit_preference`, `lecturer/delete_preference` | `lecturer/edit_preference.php`, `lecturer/delete_preference.php` |
| `lecturer/export_excel` | `lecturer/export_excel.php` |
| `lecturer/download_pdf`, `lecturer/download_pdf_backup` | `lecturer/download_pdf.php`, `lecturer/download_pdf_backup.php` |

Many other lecturer scripts (e.g. `assign_*.php`, `results.php`, `transfers.php`, grading, reports) are used via direct includes or AJAX; not all are in the router.

### 3.3 Admin routes (in index.php)

| Path | File |
|------|------|
| `admin`, `admin/` | `admin/index.php` |
| `admin/login`, `admin/logout` | `admin/login.php`, `admin/logout.php` |
| `admin/approve_transfer`, `admin/reject_transfer` | `admin/approve_transfer.php`, `admin/reject_transfer.php` |
| `admin/assign_districts`, `admin/assign_lecturers`, `admin/assign_students` | `admin/assign_districts.php`, etc. |
| `admin/manage_lecturers` | `admin/manage_lecturers.php` |
| `admin/send_sms`, `admin/teaching`, `admin/transfers` | `admin/send_sms.php`, `admin/teaching.php`, `admin/transfers.php` |
| `admin/view_lecturers`, `admin/view_student` | `admin/view_lecturers.php`, `admin/view_student.php` |
| `admin/download_pdf`, `admin/view_pdf` | `admin/download_pdf.php`, `admin/view_pdf.php` |
| `admin/fetch_assigned_districts`, `admin/fetch_districts`, `admin/fetch_mapping` | `admin/fetch_*.php` |
| `admin/grant_permission`, `admin/return_mapping`, `admin/sub_map`, `admin/try` | `admin/grant_permission.php`, etc. |

Admin has many more scripts (e.g. `students.php`, `results.php`, `broadsheet.php`, `route_allocation.php`, uploads, letters) used from within admin pages.

### 3.4 Help routes (in index.php)

| Path | File |
|------|------|
| `help/index` | `help/index.php` |
| `help/login` | `help/login.php` |
| `help/registration` | `help/registration.php` |

### 3.5 System admin (sys_admin)

**Not routed in index.php.** Accessed directly, e.g. `/ims/sys_admin/login.php`, `/ims/sys_admin/index.php`. Scripts include: `login.php`, `logout.php`, `index.php`, `insert.php`, `delete_student.php`, `clean_student_data.php`, `complete_submission.php`, `error_check.php`, `search_students.php`, `submissions_without_letters.php`, `sys_reset.php`, `verify_audit_log.php`, `view_audit_log.php`, `sys_admin_header.php`.

---

## 4. Key Directories

| Directory | Purpose |
|-----------|---------|
| **config/** | DB config (`database.php` — PDO, MySQL `internship_portal`). **Note:** Contains credentials; move to env in new version. |
| **includes/** | `header.php`, `footer.php`, `navbar.php`, `admin_header.php`, `admin_navbar.php`, `lecturer_header.php`, `functions.php`, `error_handler.php` |
| **help/** | Public-facing help: `index.php`, `login.php`, `registration.php`, `student_details.php`, `transfer_request.php`, shared `header.php`, `footer.php`, `navbar.php`, `styles.css` |
| **student/** | Registration, login, dashboard, student details, transfers, submit letter, reports, view/download submission, download evaluation, change/forgot/reset password, uploads, partials |
| **lecturer/** | Login, signup, dashboard, region/district assignment, mapping, students, results, broadsheet, transfers, grading (report/presentation/teaching), exports (Excel/PDF), SMS, preferences, swap requests, post-internship reports |
| **admin/** | Login, dashboard, assign districts/lecturers/students, transfers (approve/reject), lecturers, students, results, broadsheet, route allocation, mapping/letters, uploads (e.g. index numbers), backup/reset handlers |
| **sys_admin/** | Login, manage admin accounts (insert), student search/delete, clean data, complete submission, error check, submissions without letters, audit log (view/verify), sys reset (with password) |
| **errors/** | 404 and error pages |

---

## 5. Dependencies (composer.json)

| Package | Use |
|---------|-----|
| `phpoffice/phpspreadsheet` | Excel import/export |
| `setasign/fpdf`, `setasign/fpdi` | PDF generation/import |
| `phpoffice/phpword` | Word documents |
| `dompdf/dompdf` | HTML to PDF |
| `tecnickcom/tcpdf` | PDF generation |
| `smalot/pdfparser` | Parse PDFs |

---

## 6. Database

- **Config:** `config/database.php` (PDO, MySQL).
- **DB name:** `internship_portal`.
- **Concepts (see PROJECT_OVERVIEW.md):** users, student_details, districts, regions, groups, transfer_requests, lecturers, assignments, internship_reports, teaching reports, evaluations, sys_admin, audit log, etc.

---

## 7. New Version (Phase 1)

- **Scope:** Student module only (new codebase, modern stack).
- **Docs:** `docs/PROJECT_OVERVIEW.md`, `docs/STUDENT_MODULE_AND_START.md`.
- This index describes the **current (legacy)** PHP app; the new version will be built separately and may not mirror this file layout.

---

## 8. File Counts (approximate)

| Area | Notes |
|------|--------|
| **admin/** | ~63 PHP, plus CSS, GeoJSON, CSVs, zips |
| **lecturer/** | ~17+ PHP (many shared names with admin) |
| **student/** | ~20+ PHP, partials, uploads |
| **sys_admin/** | ~15 PHP |
| **includes/** | 8 PHP |
| **help/** | ~10 PHP/CSS/assets |
