<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}

include '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $transferId = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);

    if ($transferId) {
        // Update transfer request status to rejected
        $stmt = $pdo->prepare('UPDATE transfer_requests SET status = "rejected" WHERE id = ?');
        if ($stmt->execute([$transferId])) {
            $_SESSION['statusMessage'] = 'Transfer request rejected.';
            $_SESSION['statusType'] = 'success'; // Success alert type
        } else {
            $_SESSION['statusMessage'] = 'Failed to reject the transfer request.';
            $_SESSION['statusType'] = 'danger'; // Error alert type
        }
    } else {
        $_SESSION['statusMessage'] = 'Invalid transfer ID.';
        $_SESSION['statusType'] = 'danger'; // Error alert type
    }

    // Redirect back to transfers.php
    header('Location: transfers.php');
    exit; // Ensure the script stops after header redirection
}
