<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}

include '../config/database.php';

// Fetch all lecturers from the database
$stmt = $pdo->prepare('SELECT * FROM lecturer_login');
$stmt->execute();
$lecturers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lecturer List</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="admin_style.css" rel="stylesheet">
    <!-- FontAwesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .container {
            max-width: 1200px;
        }

        .filter-row {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 15px;
        }

        .form-select, .btn {
            max-width: 200px;
            margin-right: 10px;
        }

        .btn-outline-tomato {
            border-color: tomato;
            color: tomato;
        }

        .btn-outline-tomato:hover {
            background-color: tomato;
            color: white;
        }

        .table {
            margin-top: 15px;
        }
    </style>
</head>
<body>

<?php include 'admin_header.php'; ?>

<div class="container mt-4">
    <h2 class="mb-3">All Lecturers</h2>
    
    <div class="filter-row">
        <div class="d-flex">
            <select id="departmentFilter" class="form-select">
                <option value="">Filter by Department</option>
                <option value="Management Sciences">Management Sciences</option>
                <option value="Applied Finance">Applied Finance</option>
                <option value="Accounting">Accounting</option>
                <option value="Procurement">Procurement</option>
                <option value="Marketing">Marketing</option>
            </select>
            <button id="filterButton" class="btn btn-outline-tomato">Filter</button>
        </div>
    </div>

    <?php if (empty($lecturers)): ?>
        <p>No lecturers found.</p>
    <?php else: ?>
        <table class="table table-striped" id="lecturerTable">
            <thead>
                <tr>
                    <th>Full Name</th>
                    <th>Contact</th>
                    <th>Department</th>
                    <th>Username</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($lecturers as $lecturer): ?>
                    <tr data-department="<?php echo htmlspecialchars($lecturer['department'], ENT_QUOTES, 'UTF-8'); ?>">
                        <td><?php echo htmlspecialchars($lecturer['name'], ENT_QUOTES, 'UTF-8'); ?></td>
                        <td><?php echo htmlspecialchars($lecturer['contact'], ENT_QUOTES, 'UTF-8'); ?></td>
                        <td><?php echo htmlspecialchars($lecturer['department'], ENT_QUOTES, 'UTF-8'); ?></td>
                        <td><?php echo htmlspecialchars($lecturer['username'], ENT_QUOTES, 'UTF-8'); ?></td>
                        <td><i class="fas fa-eye" style="cursor:pointer;" data-bs-toggle="modal" data-bs-target="#lecturerDetailsModal" onclick="showLecturerDetails(<?php echo htmlspecialchars(json_encode($lecturer), ENT_QUOTES, 'UTF-8'); ?>)"></i></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<!-- Modal for Lecturer Details -->
<div class="modal fade" id="lecturerDetailsModal" tabindex="-1" aria-labelledby="lecturerDetailsModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="lecturerDetailsModalLabel">Lecturer Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="lecturerDetailsContent">
                <!-- Details will be injected here by JavaScript -->
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.getElementById('filterButton').addEventListener('click', filterTable);
    });

    function filterTable() {
        var department = document.getElementById('departmentFilter').value;
        var rows = document.querySelectorAll('#lecturerTable tbody tr');

        rows.forEach(function (row) {
            var rowDepartment = row.getAttribute('data-department');
            var show = true;

            if (department && rowDepartment !== department) {
                show = false;
            }

            row.style.display = show ? '' : 'none';
        });
    }

    function showLecturerDetails(lecturer) {
        var content = `
            <p><strong>Full Name:</strong> ${lecturer.name}</p>
            <p><strong>Contact:</strong> ${lecturer.contact}</p>
            <p><strong>Department:</strong> ${lecturer.department}</p>
            <p><strong>Username:</strong> ${lecturer.username}</p>
            ${lecturer.car_number ? `<p><strong>Car Number:</strong> ${lecturer.car_number}</p>` : ''}
            ${lecturer.mapping_submitted ? `<p><strong>Mapping Submitted:</strong> ${lecturer.mapping_submitted ? 'Yes' : 'No'}</p>` : ''}
        `;
        document.getElementById('lecturerDetailsContent').innerHTML = content;
    }
</script>
</body>
</html>
