<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}
require_once '../config/database.php';

include 'pi_header.php';

// Fetch all groups with their category
$groups = $pdo->query("
    SELECT g.id, g.group_name, g.category
    FROM pi_lecturer_groups g
    ORDER BY g.category, g.group_name
")->fetchAll(PDO::FETCH_ASSOC);

// For each group, get the number of students and lecturers
$groupData = [];
foreach ($groups as $group) {
    // Count students
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM student_details WHERE lecturer_group_id = ?");
    $stmt->execute([$group['id']]);
    $studentCount = $stmt->fetchColumn();

    // Get lecturers
    $stmt = $pdo->prepare("SELECT name FROM lecturer_login WHERE group_id = ?");
    $stmt->execute([$group['id']]);
    $lecturers = $stmt->fetchAll(PDO::FETCH_COLUMN);

    $groupData[] = [
        'name' => $group['group_name'],
        'category' => $group['category'],
        'students' => $studentCount,
        'lecturers' => $lecturers
    ];
}
?>

<style>
    .card-header.custom-dark {
        background-color: #1f2a38 !important;
        color: #fff;
    }
    .badge.bg-dark {
        background-color: #1f2a38 !important;
    }
    .badge.bg-primary {
        background-color: #4084f3 !important;
    }
    .badge.bg-success {
        background-color: #32aa53 !important;
    }
    .badge.bg-info {
        background-color: #e0e7ef !important;
        color: #1f2a38 !important;
    }
</style>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card">
                <div class="card-header custom-dark">
                    <h3 class="mb-0">
                        <i class="fas fa-users"></i> Post-Internship Group Supervision Summary
                    </h3>
                </div>
                <div class="card-body">
                    <table class="table table-striped table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th><i class="fas fa-layer-group"></i> Group Name</th>
                                <th><i class="fas fa-tag"></i> Category</th>
                                <th><i class="fas fa-user-graduate"></i> Number of Students</th>
                                <th><i class="fas fa-chalkboard-teacher"></i> Lecturers Assigned</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($groupData as $g): ?>
                                <tr>
                                    <td><?= htmlspecialchars($g['name']) ?></td>
                                    <td>
                                        <span class="badge <?= $g['category'] === 'Teaching Practice' ? 'bg-primary' : 'bg-success' ?>">
                                            <?= htmlspecialchars($g['category']) ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-dark"><?= $g['students'] ?></span>
                                    </td>
                                    <td>
                                        <?php if ($g['lecturers']): ?>
                                            <span class="badge bg-info text-dark"><?= htmlspecialchars(implode(', ', $g['lecturers'])) ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">None</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'pi_footer.php'; ?> 