<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
require '../config/database.php'; // Include database connection

// Admin session check
if (!isset($_SESSION['admin_id'])) {
    header("Location: login");
    exit;
}

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    
    // Fetch Group Details
    try {
        $sql = "SELECT * FROM pi_lecturer_groups WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $group = $stmt->fetch();
        
        if (!$group) {
            $_SESSION['error'] = "Group not found!";
            header("Location: view_groups");
            exit;
        }
    } catch (PDOException $e) {
        $_SESSION['error'] = "Error fetching group: " . $e->getMessage();
        header("Location: view_groups");
        exit;
    }
    
    // Handle Form Submission
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $new_name = trim($_POST['group_name']);
        $new_category = $_POST['category'] ?? 'Industrial Internship';
        
        if (!empty($new_name)) {
            try {
                $sql = "UPDATE pi_lecturer_groups SET group_name = :group_name, category = :category WHERE id = :id";
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':group_name', $new_name);
                $stmt->bindParam(':category', $new_category);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $stmt->execute();
                $_SESSION['success'] = "Group updated successfully!";
            } catch (PDOException $e) {
                $_SESSION['error'] = "Database Error: " . $e->getMessage();
            }
        } else {
            $_SESSION['warning'] = "Group name cannot be empty!";
        }
    }
} else {
    $_SESSION['error'] = "No group ID provided!";
    header("Location: view_groups");
    exit;
}

include('pi_header.php');
?>

<div class="container mt-5">
    <!-- Flash messages -->
    <?php foreach (['success','error','warning'] as $type): ?>
        <?php if (!empty($_SESSION[$type])): ?>
            <div class="alert alert-<?= $type === 'error' ? 'danger' : $type ?> alert-dismissible fade show">
                <?= htmlspecialchars($_SESSION[$type]) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION[$type]); ?>
        <?php endif; ?>
    <?php endforeach; ?>

    <div class="row justify-content-center">
        <!-- Adjust col-md-6 (or col-md-4) to reduce the card width -->
        <div class="col-md-6">
            <div class="card shadow-lg p-4">
                <h2 class="mb-4">Edit Lecturer Group</h2>
                <form method="post">
                    <div class="mb-3">
                        <label for="group_name" class="form-label">Group Name</label>
                        <input type="text" name="group_name" id="group_name" class="form-control" value="<?php echo htmlspecialchars($group['group_name']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="category" class="form-label">Category</label>
                        <select name="category" id="category" class="form-select">
                            <option value="Industrial Internship" <?php echo ($group['category'] === 'Industrial Internship') ? 'selected' : ''; ?>>Industrial Internship</option>
                            <option value="Teaching Practice" <?php echo ($group['category'] === 'Teaching Practice') ? 'selected' : ''; ?>>Teaching Practice</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Update Group</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    /* Auto-hide alerts after 3 seconds */
    setTimeout(() => {
        document.querySelectorAll('.alert').forEach(el => {
            el.classList.remove('show');          // Bootstrap fade
            el.addEventListener('transitionend', () => el.remove());
        });
    }, 3000);
</script>

<?php include('pi_footer.php'); ?>
