<?php
// Clear any previous output to avoid header issues
ob_clean();

// Start the session and check for admin authentication
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

// Include Composer's autoloader
require '../vendor/autoload.php'; // Adjust path if needed

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Database connection
include '../config/database.php';

// Fetch all submitted results
$query = "
    SELECT 
        sd.first_name,
        sd.surname,
        u.index_number,
        sr.marks,
        sr.grade,
        sr.gp,
        sr.description,
        l.name AS lecturer_name
    FROM student_results sr
    JOIN student_details sd ON sr.student_id = sd.id
    JOIN users u ON sd.user_id = u.id
    JOIN lecturer_login l ON sd.lecturer_id = l.id
    WHERE sr.status = 'submitted'
";
$stmt = $pdo->prepare($query);
$stmt->execute();
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Create a new spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set column headers
$sheet->setCellValue('A1', 'Index Number')
      ->setCellValue('B1', 'Student Name')
      ->setCellValue('C1', 'Lecturer Name')
      ->setCellValue('D1', 'Marks')
      ->setCellValue('E1', 'Grade')
      ->setCellValue('F1', 'GP')
      ->setCellValue('G1', 'Description');

// Populate rows with data
$row = 2;
foreach ($results as $result) {
    $sheet->setCellValue('A' . $row, $result['index_number'])
          ->setCellValue('B' . $row, $result['first_name'] . ' ' . $result['surname'])
          ->setCellValue('C' . $row, $result['lecturer_name'])
          ->setCellValue('D' . $row, $result['marks'])
          ->setCellValue('E' . $row, $result['grade'])
          ->setCellValue('F' . $row, $result['gp'])
          ->setCellValue('G' . $row, $result['description']);
    $row++;
}

// Set headers to download the file
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="submitted_results.xlsx"');
header('Cache-Control: max-age=0');

// Output the spreadsheet
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
