<?php
include '../config/database.php';

if (isset($_POST['lecturer_id']) && isset($_POST['selected_districts'])) {
    $lecturerId = $_POST['lecturer_id'];
    $region = $_POST['region'];
    $selectedDistricts = array_map('trim', $_POST['selected_districts']);

    // Delete old assignments
    $query = 'DELETE FROM lecturer_assigned_districts WHERE lecturer_id = :lecturer_id AND region = :region';
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':lecturer_id', $lecturerId);
    $stmt->bindParam(':region', $region);
    $stmt->execute();

    // Insert new assignments
    $query = 'INSERT INTO lecturer_assigned_districts (lecturer_id, district, region) VALUES (:lecturer_id, :district, :region)';
    $stmt = $pdo->prepare($query);

    foreach ($selectedDistricts as $district) {
        $stmt->bindParam(':lecturer_id', $lecturerId);
        $stmt->bindParam(':district', $district);
        $stmt->bindParam(':region', $region);
        $stmt->execute();
    }

    header('Location: assign_district.php');
    exit;
} else {
    echo "Error: No districts selected or lecturer ID is missing.";
}
?>
