<?php
require '../vendor/setasign/fpdf/fpdf.php';

if (isset($_GET['PHPSESSID'])) {
    session_id(htmlspecialchars($_GET['PHPSESSID'], ENT_QUOTES, 'UTF-8'));
}
session_start();

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php';

// Sanitize the lecturer ID input
$lecturerId = isset($_GET['lecturer_id']) ? htmlspecialchars($_GET['lecturer_id'], ENT_QUOTES, 'UTF-8') : null;

if (!$lecturerId) {
    die("Lecturer ID is required.");
}

// Fetch lecturer details
$stmt = $pdo->prepare('SELECT name, car_number, staff_id, department FROM lecturer_login WHERE id = ?');
$stmt->execute([$lecturerId]);
$lecturer = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$lecturer) {
    die("Lecturer not found.");
}

// Fetch supervision data
$stmt = $pdo->prepare('
    SELECT sm.date_of_supervision, sm.student_name, u.index_number, sm.from_location, sm.to_location, sm.distance, sm.nights
    FROM supervision_mapping sm
    LEFT JOIN student_details sd ON sm.student_name = CONCAT(sd.first_name, " ", sd.surname)
    LEFT JOIN users u ON sd.user_id = u.id
    WHERE sm.lecturer_id = ?
');
$stmt->execute([$lecturerId]);
$supervisionData = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Calculate totals
$totalDistance = 0;
$totalNights = 0;
foreach ($supervisionData as $data) {
    $totalDistance += $data['distance'];
    $totalNights += $data['nights'];
}

class PDF extends FPDF {
    function Header() {
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 5, 'UNIVERSITY OF EDUCATION, WINNEBA', 0, 1, 'C');
        $this->Cell(0, 5, 'SCHOOL OF BUSINESS', 0, 1, 'C');
        $this->Cell(0, 5, 'INTERNSHIP CLAIM FOR THE 2024/25 ACADEMIC YEAR', 0, 1, 'C');
        $this->Ln(5);
    }

    function LecturerDetails($lecturer) {
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 5, 'Name: ' . htmlspecialchars($lecturer['name'], ENT_QUOTES, 'UTF-8'), 0, 1);
        $this->Cell(0, 5, 'Staff No.: ' . htmlspecialchars($lecturer['staff_id'], ENT_QUOTES, 'UTF-8'), 0, 1);
        $this->Cell(0, 5, 'Car Reg. No.: ' . htmlspecialchars($lecturer['car_number'], ENT_QUOTES, 'UTF-8'), 0, 1);
        $this->Cell(0, 5, 'Department: ' . htmlspecialchars($lecturer['department'], ENT_QUOTES, 'UTF-8'), 0, 1);
        $this->Ln(5);
    }

    function SupervisionTable($header, $data, $totalDistance, $totalNights) {
        $this->SetFont('Arial', 'B', 10);
        $widths = [30, 50, 30, 40, 40, 30, 20];
        for ($i = 0; $i < count($header); $i++) {
            $this->Cell($widths[$i], 7, htmlspecialchars($header[$i], ENT_QUOTES, 'UTF-8'), 1, 0, 'C');
        }
        $this->Ln();
        $this->SetFont('Arial', '', 10);

        foreach ($data as $row) {
            $maxHeight = $this->GetMultiCellHeight($row, $widths);

            $x = $this->GetX();
            $y = $this->GetY();

            $this->MultiCell($widths[0], $maxHeight / $this->NbLines($widths[0], htmlspecialchars($row['date_of_supervision'], ENT_QUOTES, 'UTF-8')), htmlspecialchars($row['date_of_supervision'], ENT_QUOTES, 'UTF-8'), 1, 'L');
            $this->SetXY($x + $widths[0], $y);
            $this->MultiCell($widths[1], $maxHeight / $this->NbLines($widths[1], htmlspecialchars($row['student_name'], ENT_QUOTES, 'UTF-8')), htmlspecialchars($row['student_name'], ENT_QUOTES, 'UTF-8'), 1, 'L');
            $this->SetXY($x + $widths[0] + $widths[1], $y);
            $this->MultiCell($widths[2], $maxHeight / $this->NbLines($widths[2], htmlspecialchars($row['index_number'], ENT_QUOTES, 'UTF-8')), htmlspecialchars($row['index_number'], ENT_QUOTES, 'UTF-8'), 1, 'L');
            $this->SetXY($x + $widths[0] + $widths[1] + $widths[2], $y);
            $this->MultiCell($widths[3], $maxHeight / $this->NbLines($widths[3], htmlspecialchars($row['from_location'], ENT_QUOTES, 'UTF-8')), htmlspecialchars($row['from_location'], ENT_QUOTES, 'UTF-8'), 1, 'L');
            $this->SetXY($x + $widths[0] + $widths[1] + $widths[2] + $widths[3], $y);
            $this->MultiCell($widths[4], $maxHeight / $this->NbLines($widths[4], htmlspecialchars($row['to_location'], ENT_QUOTES, 'UTF-8')), htmlspecialchars($row['to_location'], ENT_QUOTES, 'UTF-8'), 1, 'L');
            $this->SetXY($x + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4], $y);
            $this->MultiCell($widths[5], $maxHeight / $this->NbLines($widths[5], number_format($row['distance'], 2)), number_format($row['distance'], 2), 1, 'L');
            $this->SetXY($x + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4] + $widths[5], $y);
            $this->MultiCell($widths[6], $maxHeight / $this->NbLines($widths[6], htmlspecialchars($row['nights'], ENT_QUOTES, 'UTF-8')), htmlspecialchars($row['nights'], ENT_QUOTES, 'UTF-8'), 1, 'L');

            $this->SetXY($x, $y + $maxHeight);
        }

        // Add totals
        $this->Cell(array_sum(array_slice($widths, 0, 5)), 6, 'Total', 1);
        $this->Cell($widths[5], 6, number_format($totalDistance, 2), 1);
        $this->Cell($widths[6], 6, htmlspecialchars($totalNights, ENT_QUOTES, 'UTF-8'), 1);
        $this->Ln(10); // Space before the signature
        $this->Cell(0, 10, 'Signature: ........................................', 0, 1, 'L');
        
        // Add the current date
        $this->Cell(0, 10, 'Date: ' . date('d-M-Y'), 0, 1, 'L');
    }

    function GetMultiCellHeight($row, $widths) {
        $nbLines = max(
            $this->NbLines($widths[0], htmlspecialchars($row['date_of_supervision'], ENT_QUOTES, 'UTF-8')),
            $this->NbLines($widths[1], htmlspecialchars($row['student_name'], ENT_QUOTES, 'UTF-8')),
            $this->NbLines($widths[2], htmlspecialchars($row['index_number'], ENT_QUOTES, 'UTF-8')),
            $this->NbLines($widths[3], htmlspecialchars($row['from_location'], ENT_QUOTES, 'UTF-8')),
            $this->NbLines($widths[4], htmlspecialchars($row['to_location'], ENT_QUOTES, 'UTF-8')),
            $this->NbLines($widths[5], number_format($row['distance'], 2)),
            $this->NbLines($widths[6], htmlspecialchars($row['nights'], ENT_QUOTES, 'UTF-8'))
        );

        return 6 * $nbLines;
    }

    function NbLines($w, $txt) {
        // Calculates the number of lines a MultiCell of width w will take
        $cw = &$this->CurrentFont['cw'];
        if ($w == 0)
            $w = $this->w - $this->rMargin - $this->x;
        $wmax = ($w - 2 * $this->cMargin) * 1000 / $this->FontSize;
        $s = str_replace("\r", '', $txt);
        $nb = strlen($s);
        if ($nb > 0 && $s[$nb - 1] == "\n")
            $nb--;
        $sep = -1;
        $i = 0;
        $j = 0;
        $l = 0;
        $nl = 1;
        while ($i < $nb) {
            $c = $s[$i];
            if ($c == "\n") {
                $i++;
                $sep = -1;
                $j = $i;
                $l = 0;
                $nl++;
                continue;
            }
            if ($c == ' ')
                $sep = $i;
            $l += $cw[$c];
            if ($l > $wmax) {
                if ($sep == -1) {
                    if ($i == $j)
                        $i++;
                } else
                    $i = $sep + 1;
                $sep = -1;
                $j = $i;
                $l = 0;
                $nl++;
            } else
                $i++;
        }
        return $nl;
    }
}

$pdf = new PDF('L', 'mm', 'A4');
$pdf->AddPage();
$pdf->LecturerDetails($lecturer);
$pdf->SupervisionTable(['Date', 'Student', 'Index', 'From', 'To', 'Distance (KM)', 'Nights'], $supervisionData, $totalDistance, $totalNights);

$pdf->Output('I', 'mapping.pdf'); // Output PDF inline in the browser
?>
