<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}
include '../includes/admin_header.php';
include '../config/database.php';

// Fetch all lecturers and their preferences
$stmt = $pdo->prepare('SELECT l.id, l.name, l.department, lp.preferred_region, lp.preferred_districts
                       FROM lecturer_login l
                       LEFT JOIN lecturer_preferences lp ON l.id = lp.lecturer_id');
$stmt->execute();
$lecturers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <h2>Lecturers and Their Preferred Regions</h2>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Lecturer Name</th>
                <th>Department</th>
                <th>Preferred Region</th>
                <th>Preferred Districts</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($lecturers as $lecturer): ?>
                <tr>
                    <td><?php echo htmlspecialchars($lecturer['name'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($lecturer['department'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($lecturer['preferred_region'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($lecturer['preferred_districts'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td>
                        <a href="assign_students.php?lecturer_id=<?php echo htmlspecialchars($lecturer['id'], ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-primary btn-sm">Assign Students</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include '../../includes/footer.php'; ?>
