<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}
include '../includes/admin_header.php';
include '../config/database.php';

// Fetch distinct values for filters
$stmt = $pdo->prepare('SELECT DISTINCT region FROM districts');
$stmt->execute();
$regions = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $pdo->prepare('SELECT DISTINCT course FROM student_details');
$stmt->execute();
$courses = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $pdo->prepare('SELECT DISTINCT organisation_name FROM student_details');
$stmt->execute();
$organisations = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch students based on selected filters
$selectedRegion = isset($_GET['region']) ? htmlspecialchars($_GET['region'], ENT_QUOTES, 'UTF-8') : '';
$selectedDistrict = isset($_GET['district']) ? htmlspecialchars($_GET['district'], ENT_QUOTES, 'UTF-8') : '';
$selectedCourse = isset($_GET['course']) ? htmlspecialchars($_GET['course'], ENT_QUOTES, 'UTF-8') : '';
$selectedOrganisation = isset($_GET['organisation']) ? htmlspecialchars($_GET['organisation'], ENT_QUOTES, 'UTF-8') : '';

$query = 'SELECT * FROM student_details WHERE `group` = "Teaching Practice"';
$conditions = [];

if ($selectedRegion) {
    $conditions[] = 'region = :region';
}
if ($selectedDistrict) {
    $conditions[] = 'district = :district';
}
if ($selectedCourse) {
    $conditions[] = 'course = :course';
}
if ($selectedOrganisation) {
    $conditions[] = 'organisation_name = :organisation';
}

if ($conditions) {
    $query .= ' AND ' . implode(' AND ', $conditions);
}

$stmt = $pdo->prepare($query);

if ($selectedRegion) {
    $stmt->bindParam(':region', $selectedRegion);
}
if ($selectedDistrict) {
    $stmt->bindParam(':district', $selectedDistrict);
}
if ($selectedCourse) {
    $stmt->bindParam(':course', $selectedCourse);
}
if ($selectedOrganisation) {
    $stmt->bindParam(':organisation', $selectedOrganisation);
}

$stmt->execute();
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <h2>Teaching Practice</h2>
    <form method="GET" action="teaching.php" class="mb-4">
        <div class="row">
            <div class="col-md-3">
                <select name="region" id="region" class="form-select">
                    <option value="">Select Region</option>
                    <?php foreach ($regions as $region): ?>
                        <option value="<?php echo htmlspecialchars($region['region'], ENT_QUOTES, 'UTF-8'); ?>" <?php echo $selectedRegion === $region['region'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($region['region'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3">
                <select name="district" id="district" class="form-select">
                    <option value="">Select District</option>
                </select>
            </div>
            <div class="col-md-3">
                <select name="course" class="form-select">
                    <option value="">Select Course</option>
                    <?php foreach ($courses as $course): ?>
                        <option value="<?php echo htmlspecialchars($course['course'], ENT_QUOTES, 'UTF-8'); ?>" <?php echo $selectedCourse === $course['course'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($course['course'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3">
                <select name="organisation" class="form-select">
                    <option value="">Select Organisation</option>
                    <?php foreach ($organisations as $organisation): ?>
                        <option value="<?php echo htmlspecialchars($organisation['organisation_name'], ENT_QUOTES, 'UTF-8'); ?>" <?php echo $selectedOrganisation === $organisation['organisation_name'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($organisation['organisation_name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
        <div class="mt-3">
            <button class="btn btn-primary" type="submit">Filter</button>
        </div>
    </form>

    <?php if (count($students) > 0): ?>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>User ID</th>
                <th>Name</th>
                <th>School</th>
                <th>District</th>
                <th>Region</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($students as $student): ?>
                <tr>
                    <td><?php echo htmlspecialchars($student['user_id'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($student['organisation_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($student['district'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($student['region'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><a href="view_student.php?id=<?php echo htmlspecialchars($student['id'], ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-info btn-sm">View</a></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php else: ?>
        <p>No students found for the selected filters.</p>
    <?php endif; ?>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const regionSelect = document.getElementById('region');
        const districtSelect = document.getElementById('district');

        regionSelect.addEventListener('change', function () {
            const region = this.value;
            districtSelect.innerHTML = '<option value="">Select District</option>';

            if (region) {
                fetch('fetch_districts.php?region=' + encodeURIComponent(region))
                    .then(response => response.json())
                    .then(data => {
                        data.forEach(district => {
                            const option = document.createElement('option');
                            option.value = district.district;
                            option.textContent = district.district;
                            districtSelect.appendChild(option);
                        });
                    })
                    .catch(error => console.error('Error fetching districts:', error));
            }
        });

        // Trigger change event on page load to populate district if region is already selected
        if (regionSelect.value) {
            const event = new Event('change');
            regionSelect.dispatchEvent(event);
        }
    });
</script>

<?php include '../../includes/footer.php'; ?>
