<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

require('../vendor/fpdf/fpdf.php'); // Include FPDF library
include '../config/database.php';

if (!isset($_GET['lecturer_id'])) {
    http_response_code(400);
    echo "Invalid request";
    exit;
}

// Sanitize and validate the lecturer_id parameter
$lecturerId = htmlspecialchars($_GET['lecturer_id'], ENT_QUOTES, 'UTF-8');

if (!is_numeric($lecturerId)) {
    http_response_code(400);
    echo "Invalid lecturer ID";
    exit;
}

// Fetch the data from the mapping table
$stmt = $pdo->prepare('
    SELECT date_of_supervision, student_name, index_number, from_location, to_location, distance, nights
    FROM mapping
    WHERE lecturer_id = ?
');
$stmt->execute([$lecturerId]);
$mappingData = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($mappingData)) {
    http_response_code(404);
    echo "No data found";
    exit;
}

// Generate PDF
$pdf = new FPDF('L', 'mm', 'A4');
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'Supervision Mapping', 0, 1, 'C');
$pdf->Ln(10);

$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(30, 7, 'Date', 1);
$pdf->Cell(50, 7, 'Student', 1);
$pdf->Cell(30, 7, 'Index', 1);
$pdf->Cell(40, 7, 'From', 1);
$pdf->Cell(40, 7, 'To', 1);
$pdf->Cell(30, 7, 'Distance (KM)', 1);
$pdf->Cell(20, 7, 'Nights', 1);
$pdf->Ln();

$pdf->SetFont('Arial', '', 10);
foreach ($mappingData as $row) {
    $pdf->Cell(30, 7, htmlspecialchars($row['date_of_supervision'], ENT_QUOTES, 'UTF-8'), 1);
    $pdf->Cell(50, 7, htmlspecialchars($row['student_name'], ENT_QUOTES, 'UTF-8'), 1);
    $pdf->Cell(30, 7, htmlspecialchars($row['index_number'], ENT_QUOTES, 'UTF-8'), 1);
    $pdf->Cell(40, 7, htmlspecialchars($row['from_location'], ENT_QUOTES, 'UTF-8'), 1);
    $pdf->Cell(40, 7, htmlspecialchars($row['to_location'], ENT_QUOTES, 'UTF-8'), 1);
    $pdf->Cell(30, 7, number_format($row['distance'], 2), 1);
    $pdf->Cell(20, 7, htmlspecialchars($row['nights'], ENT_QUOTES, 'UTF-8'), 1);
    $pdf->Ln();
}

// Output PDF as base64-encoded string
$pdfString = $pdf->Output('S');
$downloadLink = 'download_pdf.php?lecturer_id=' . urlencode($lecturerId);
echo json_encode(['pdf' => base64_encode($pdfString), 'downloadLink' => htmlspecialchars($downloadLink, ENT_QUOTES, 'UTF-8')]);
?>
