<?php
require '../vendor/autoload.php'; // Adjust the path as necessary if not using Composer

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Start the session and check for admin authentication
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php';

// Fetch all results entered by lecturers from student_results table
$query = "
    SELECT 
        sd.first_name,
        sd.surname,
        u.index_number,
        sr.marks,
        sr.grade,
        sr.gp,
        sr.description,
        l.name AS lecturer_name
    FROM student_results sr
    JOIN student_details sd ON sr.student_id = sd.id
    JOIN users u ON sd.user_id = u.id
    JOIN lecturer_login l ON sd.lecturer_id = l.id
";
$stmt = $pdo->prepare($query);
$stmt->execute();
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Create a new Spreadsheet object
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set the header of the Excel file
$sheet->setCellValue('A1', 'Index Number')
      ->setCellValue('B1', 'Student Name')
      ->setCellValue('C1', 'Lecturer Name')
      ->setCellValue('D1', 'Marks')
      ->setCellValue('E1', 'Grade')
      ->setCellValue('F1', 'GP')
      ->setCellValue('G1', 'Description');

// Populate the Excel sheet with data
$row = 2;
foreach ($results as $result) {
    $sheet->setCellValue('A' . $row, $result['index_number'])
          ->setCellValue('B' . $row, $result['first_name'] . ' ' . $result['surname'])
          ->setCellValue('C' . $row, $result['lecturer_name'])
          ->setCellValue('D' . $row, $result['marks'])
          ->setCellValue('E' . $row, $result['grade'])
          ->setCellValue('F' . $row, $result['gp'])
          ->setCellValue('G' . $row, $result['description']);
    $row++;
}

// Set headers to download the file rather than displaying it
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="results.xlsx"');
header('Cache-Control: max-age=0');

// Write the spreadsheet to the output buffer
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
