<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}
include '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $transferId = htmlspecialchars($_POST['id'], ENT_QUOTES, 'UTF-8');

    // Fetch the transfer request details
    $stmt = $pdo->prepare('SELECT * FROM transfer_requests WHERE id = ?');
    $stmt->execute([$transferId]);
    $transfer = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($transfer) {
        $userId = htmlspecialchars($transfer['user_id'], ENT_QUOTES, 'UTF-8');

        // Fetch the current student details
        $stmt = $pdo->prepare('SELECT * FROM student_details WHERE user_id = ?');
        $stmt->execute([$userId]);
        $currentDetails = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($currentDetails) {
            // Insert current details into former_organisations table
            $stmt = $pdo->prepare('
                INSERT INTO former_organisations (user_id, organisation_name, location, gps_location, district, region, transfer_id)
                VALUES (?, ?, ?, ?, ?, ?, ?)
            ');
            $stmt->execute([
                $userId,
                htmlspecialchars($currentDetails['organisation_name'], ENT_QUOTES, 'UTF-8'),
                htmlspecialchars($currentDetails['location'], ENT_QUOTES, 'UTF-8'),
                htmlspecialchars($currentDetails['gps_location'], ENT_QUOTES, 'UTF-8'),
                htmlspecialchars($currentDetails['district'], ENT_QUOTES, 'UTF-8'),
                htmlspecialchars($currentDetails['region'], ENT_QUOTES, 'UTF-8'),
                $transferId
            ]);

            // Update student_details with the new organisation details
            $stmt = $pdo->prepare('
                UPDATE student_details SET 
                    organisation_name = ?, 
                    location = ?, 
                    gps_location = ?, 
                    district = ?, 
                    region = ? 
                WHERE user_id = ?
            ');
            $stmt->execute([
                htmlspecialchars($transfer['new_organisation_name'], ENT_QUOTES, 'UTF-8'),
                htmlspecialchars($transfer['new_location'], ENT_QUOTES, 'UTF-8'),
                htmlspecialchars($transfer['new_gps_location'], ENT_QUOTES, 'UTF-8'),
                htmlspecialchars($transfer['new_district'], ENT_QUOTES, 'UTF-8'),
                htmlspecialchars($transfer['new_region'], ENT_QUOTES, 'UTF-8'),
                $userId
            ]);

            // Update the transfer request status to approved
            $stmt = $pdo->prepare('UPDATE transfer_requests SET status = "approved" WHERE id = ?');
            $stmt->execute([$transferId]);

            // Send SMS notification to the student
            $phone = htmlspecialchars($currentDetails['telephone'], ENT_QUOTES, 'UTF-8');
            $message = 'Your transfer request has been approved. Your new organisation is ' . htmlspecialchars($transfer['new_organisation_name'], ENT_QUOTES, 'UTF-8') . '.';

            $smsUrl = 'send_sms.php?phone=' . urlencode($phone) . '&message=' . urlencode($message);
            $smsResponse = file_get_contents($smsUrl);

            $_SESSION['statusMessage'] = 'Transfer request approved and student details updated. SMS notification sent.';
            echo 'success';
        } else {
            $_SESSION['statusMessage'] = 'Student details not found.';
            echo 'error';
        }
    } else {
        $_SESSION['statusMessage'] = 'Transfer request not found.';
        echo 'error';
    }
}
?>
