<?php
session_start();
if (!isset($_SESSION['lecturer_id'])) {
    header('Location: login.php');
    exit;
}

include 'lect_header.php';
include '../config/database.php';

$lecturerId = $_SESSION['lecturer_id'];

// Check if mapping has been submitted
$stmt = $pdo->prepare('SELECT mapping_submitted FROM lecturer_login WHERE id = ?');
$stmt->execute([$lecturerId]);
$mappingSubmitted = $stmt->fetchColumn();

// Fetch assigned students' details along with their index numbers from the users table
$stmt = $pdo->prepare('
    SELECT sd.id, sd.first_name, sd.surname, u.index_number, sd.organisation_name 
    FROM student_details sd 
    JOIN users u ON sd.user_id = u.id
    WHERE sd.lecturer_id = ?
');
$stmt->execute([$lecturerId]);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch existing supervision data
$stmt = $pdo->prepare('SELECT * FROM supervision_mapping WHERE lecturer_id = ?');
$stmt->execute([$lecturerId]);
$supervisionData = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <h2>Supervision Data</h2>
    <?php if ($mappingSubmitted): ?>
        <p>The mapping has been submitted and cannot be edited.</p>
    <?php else: ?>
        <form id="supervisionForm" method="POST" action="submit_mapping.php">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Date of Supervision</th>
                        <th>Student Name</th>
                        <th>Index Number</th>
                        <th>From</th>
                        <th>To</th>
                        <th>Distance (KM)</th>
                        <th>Nights</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody id="supervisionTableBody">
                    <?php foreach ($supervisionData as $data): ?>
                        <tr>
                            <td><input type="date" name="date_of_supervision[]" value="<?php echo htmlspecialchars($data['date_of_supervision']); ?>" class="form-control" required></td>
                            <td>
                                <select name="student_name[]" class="form-control">
                                    <option value="">Select Student</option>
                                    <?php foreach ($students as $student): ?>
                                        <option value="<?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?>" 
                                                data-index="<?php echo htmlspecialchars($student['index_number']); ?>" 
                                                <?php echo ($data['student_name'] == $student['first_name'] . ' ' . $student['surname']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                    <option value="Other" <?php echo (is_null($data['student_name'])) ? 'selected' : ''; ?>>Other</option>
                                </select>
                            </td>
                            <td><input type="text" name="index_number[]" value="<?php echo htmlspecialchars($data['index_number']); ?>" class="form-control" readonly></td>
                            <td>
                                <select name="from_location[]" class="form-control from-location-select">
                                    <?php foreach ($students as $student): ?>
                                        <option value="<?php echo htmlspecialchars($student['organisation_name']); ?>" 
                                                <?php echo ($data['from_location'] == $student['organisation_name']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($student['organisation_name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                    <option value="Other" <?php echo (!in_array($data['from_location'], array_column($students, 'organisation_name'))) ? 'selected' : ''; ?>>Other</option>
                                </select>
                                <input type="text" name="from_location_other[]" class="form-control from-location-other" style="<?php echo (!in_array($data['from_location'], array_column($students, 'organisation_name'))) ? '' : 'display: none;'; ?>" value="<?php echo htmlspecialchars($data['from_location']); ?>" placeholder="Enter other location">
                            </td>
                            <td>
                                <select name="to_location[]" class="form-control to-location-select">
                                    <?php foreach ($students as $student): ?>
                                        <option value="<?php echo htmlspecialchars($student['organisation_name']); ?>" 
                                                <?php echo ($data['to_location'] == $student['organisation_name']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($student['organisation_name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                    <option value="Other" <?php echo (!in_array($data['to_location'], array_column($students, 'organisation_name'))) ? 'selected' : ''; ?>>Other</option>
                                </select>
                                <input type="text" name="to_location_other[]" class="form-control to-location-other" style="<?php echo (!in_array($data['to_location'], array_column($students, 'organisation_name'))) ? '' : 'display: none;'; ?>" value="<?php echo htmlspecialchars($data['to_location']); ?>" placeholder="Enter other location">
                            </td>
                            <td><input type="number" step="0.1" name="distance[]" value="<?php echo htmlspecialchars($data['distance']); ?>" class="form-control distance" required></td>
                            <td><input type="number" name="nights[]" value="<?php echo htmlspecialchars($data['nights']); ?>" class="form-control nights" required></td>
                            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <button type="button" class="btn btn-primary" id="addRow">Add Row</button>
            <button type="submit" name="save" class="btn btn-success">Save</button>
            <button type="submit" name="submit" class="btn btn-primary">Submit</button>
        </form>
    <?php endif; ?>
    <div class="mt-3">
        <p><strong>Total Distance (KM):</strong> <span id="totalDistance">0</span></p>
        <p><strong>Total Nights:</strong> <span id="totalNights">0</span></p>
    </div>
    <!-- Updated Dropdown Button for Download -->
    <div class="mt-3 d-flex justify-content-between">
        <div class="btn-group">
            <button type="button" class="btn btn-outline-custom dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                Download
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="download_pdf.php">PDF</a></li>
                <li><a class="dropdown-item" href="export_excel.php">Excel</a></li>
            </ul>
        </div>
    </div>
</div>

<script>
document.querySelectorAll('.from-location-select, .to-location-select').forEach(select => {
    select.addEventListener('change', function() {
        const otherInput = this.nextElementSibling;
        if (this.value === 'Other') {
            otherInput.style.display = 'block';
            otherInput.required = true;
        } else {
            otherInput.style.display = 'none';
            otherInput.required = false;
        }
    });
});

document.getElementById('addRow').addEventListener('click', function() {
    const row = document.createElement('tr');
    row.innerHTML = `
        <td><input type="date" name="date_of_supervision[]" class="form-control" required></td>
        <td>
            <select name="student_name[]" class="form-control">
                <option value="">Select Student</option>
                <?php foreach ($students as $student): ?>
                    <option value="<?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?>" data-index="<?php echo htmlspecialchars($student['index_number']); ?>">
                        <?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?>
                    </option>
                <?php endforeach; ?>
                <option value="Other">Other</option>
            </select>
        </td>
        <td><input type="text" name="index_number[]" class="form-control" readonly></td>
        <td>
            <select name="from_location[]" class="form-control from-location-select">
                <?php foreach ($students as $student): ?>
                    <option value="<?php echo htmlspecialchars($student['organisation_name']); ?>">
                        <?php echo htmlspecialchars($student['organisation_name']); ?>
                    </option>
                <?php endforeach; ?>
                <option value="Other">Other</option>
            </select>
            <input type="text" name="from_location_other[]" class="form-control from-location-other" style="display: none;" placeholder="Enter other location">
        </td>
        <td>
            <select name="to_location[]" class="form-control to-location-select">
                <?php foreach ($students as $student): ?>
                    <option value="<?php echo htmlspecialchars($student['organisation_name']); ?>">
                        <?php echo htmlspecialchars($student['organisation_name']); ?>
                    </option>
                <?php endforeach; ?>
                <option value="Other">Other</option>
            </select>
            <input type="text" name="to_location_other[]" class="form-control to-location-other" style="display: none;" placeholder="Enter other location">
        </td>
        <td><input type="number" step="0.1" name="distance[]" class="form-control distance" required></td>
        <td><input type="number" name="nights[]" class="form-control nights" required></td>
        <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
    `;
    document.getElementById('supervisionTableBody').appendChild(row);

    // Add event listener for new select elements
    document.querySelectorAll('.from-location-select, .to-location-select').forEach(select => {
        select.addEventListener('change', function() {
            const otherInput = this.nextElementSibling;
            if (this.value === 'Other') {
                otherInput.style.display = 'block';
                otherInput.required = true;
            } else {
                otherInput.style.display = 'none';
                otherInput.required = false;
            }
        });
    });

    updateTotals();
});

document.addEventListener('click', function(e) {
    if (e.target && e.target.classList.contains('remove-row')) {
        if (confirm('Are you sure you want to remove this row?')) {
            e.target.closest('tr').remove();
            updateTotals();
        }
    }
});

document.addEventListener('change', function(e) {
    if (e.target && e.target.name === 'student_name[]') {
        const indexInput = e.target.closest('tr').querySelector('input[name="index_number[]"]');
        const selectedOption = e.target.selectedOptions[0];
        indexInput.value = selectedOption.getAttribute('data-index') || '';
    }
    if (e.target && (e.target.classList.contains('distance') || e.target.classList.contains('nights'))) {
        updateTotals();
    }
});

function updateTotals() {
    let totalDistance = 0;
    let totalNights = 0;

    document.querySelectorAll('.distance').forEach(input => {
        totalDistance += parseFloat(input.value) || 0;
    });

    document.querySelectorAll('.nights').forEach(input => {
        totalNights += parseInt(input.value) || 0;
    });

    document.getElementById('totalDistance').textContent = totalDistance.toFixed(2);
    document.getElementById('totalNights').textContent = totalNights;
}

updateTotals();
</script>

<?php include 'lect_footer.php'; ?>
