<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lecturer Signup</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <style>
        html, body {
            height: 100%;
            margin: 0;
        }
        .wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .content {
            flex: 1;
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <?php
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        include 'lect_header.php';
        ?>

        <div class="content">
            <div class="container mt-5 d-flex justify-content-center">
                <div class="card w-100" style="max-width: 600px;">
                    <div class="card-header">
                        <h2>Signup</h2>
                    </div>
                    <div class="card-body">
                        <!-- Display error messages -->
                        <?php if (isset($_GET['error'])): ?>
                            <div class="alert alert-danger">
                                <?php
                                switch ($_GET['error']) {
                                    case 'username_exists':
                                        echo htmlspecialchars("Username already exists.");
                                        break;
                                    case 'password_mismatch':
                                        echo htmlspecialchars("Passwords do not match.");
                                        break;
                                    case 'missing_fields':
                                        echo htmlspecialchars("Please fill in all fields.");
                                        break;
                                    case 'invalid_staff_id':
                                        echo htmlspecialchars("Invalid staff ID. Please provide a valid staff ID.");
                                        break;
                                    case 'staff_id_already_registered':
                                        echo htmlspecialchars("This staff ID is already registered. Please log in or contact support.");
                                        break;
                                    default:
                                        echo htmlspecialchars("An unknown error occurred.");
                                }
                                ?>
                            </div>
                        <?php endif; ?>

                        <!-- Signup form -->
                        <form method="POST" action="signup_action.php">
                            <div class="mb-3">
                                <label for="name" class="form-label">Full Name</label>
                                <input type="text" class="form-control" id="name" name="name" value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="contact" class="form-label">Contact</label>
                                <input type="text" class="form-control" id="contact" name="contact" value="<?php echo isset($_POST['contact']) ? htmlspecialchars($_POST['contact']) : ''; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="department" class="form-label">Department</label>
                                <select class="form-control" id="department" name="department" required>
                                    <option value="">Select Department</option>
                                    <option value="Management Sciences" <?php echo isset($_POST['department']) && $_POST['department'] === 'Management Sciences' ? 'selected' : ''; ?>>Management Sciences</option>
                                    <option value="Applied Finance" <?php echo isset($_POST['department']) && $_POST['department'] === 'Applied Finance' ? 'selected' : ''; ?>>Applied Finance</option>
                                    <option value="Accounting" <?php echo isset($_POST['department']) && $_POST['department'] === 'Accounting' ? 'selected' : ''; ?>>Accounting</option>
                                    <option value="Procurement" <?php echo isset($_POST['department']) && $_POST['department'] === 'Procurement' ? 'selected' : ''; ?>>Procurement</option>
                                    <option value="Marketing" <?php echo isset($_POST['department']) && $_POST['department'] === 'Marketing' ? 'selected' : ''; ?>>Marketing</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="staff_id" class="form-label">Staff ID</label>
                                <input type="text" class="form-control" id="staff_id" name="staff_id" value="<?php echo isset($_POST['staff_id']) ? htmlspecialchars($_POST['staff_id']) : ''; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="car_number" class="form-label">Car Number</label>
                                <input type="text" class="form-control" id="car_number" name="car_number" value="<?php echo isset($_POST['car_number']) ? htmlspecialchars($_POST['car_number']) : ''; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="username" class="form-label">Username</label>
                                <input type="text" class="form-control" id="username" name="username" value="<?php echo isset($_POST['username']) ? htmlspecialchars($_POST['username']) : ''; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="password" name="password" required>
                                    <span class="input-group-text" id="togglePassword">
                                        <i class="fas fa-eye"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="confirmPassword" class="form-label">Confirm Password</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" required>
                                    <span class="input-group-text" id="toggleConfirmPassword">
                                        <i class="fas fa-eye"></i>
                                    </span>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-user-plus"></i> Signup
                            </button>
                        </form>
                        <div class="mt-3 text-center">
                            <p>Already have an account? <a href="login.php">Login here</a>.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include 'lect_footer.php'; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/js/all.min.js"></script>
    <script>
        document.getElementById('togglePassword').addEventListener('click', function () {
            const passwordField = document.getElementById('password');
            const icon = this.querySelector('i');
            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                passwordField.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });

        document.getElementById('toggleConfirmPassword').addEventListener('click', function () {
            const passwordField = document.getElementById('confirmPassword');
            const icon = this.querySelector('i');
            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                passwordField.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
    </script>
</body>
</html>
