<?php
ob_start(); // Start output buffering
session_start();
if (!isset($_SESSION['lecturer_id'])) {
    header('Location: login.php');
    exit;
}
include 'lect_header.php';
include '../config/database.php';

$lecturerId = $_SESSION['lecturer_id'];
$successMessage = "";

// Handle form submission for "Save" or "Submit"
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date_of_supervision = isset($_POST['date_of_supervision']) ? $_POST['date_of_supervision'] : [];
    $student_name = isset($_POST['student_name']) ? $_POST['student_name'] : [];
    $index_number = isset($_POST['index_number']) ? $_POST['index_number'] : [];
    $from_location = isset($_POST['from_location']) ? $_POST['from_location'] : [];
    $from_location_other = isset($_POST['from_location_other']) ? $_POST['from_location_other'] : [];
    $to_location = isset($_POST['to_location']) ? $_POST['to_location'] : [];
    $to_location_other = isset($_POST['to_location_other']) ? $_POST['to_location_other'] : [];
    $distance = isset($_POST['distance']) ? $_POST['distance'] : [];
    $nights = isset($_POST['nights']) ? $_POST['nights'] : [];
    $status = isset($_POST['save']) ? 'Saved' : 'Submitted';

    if (!empty($date_of_supervision) && count($date_of_supervision) > 0) {
        // Delete existing data for the lecturer
        $stmt = $pdo->prepare('DELETE FROM supervision_mapping WHERE lecturer_id = ?');
        $stmt->execute([$lecturerId]);

        // Insert the new data into the supervision_mapping table
        for ($i = 0; $i < count($date_of_supervision); $i++) {
            $fromLocation = ($from_location[$i] === 'Other') 
                ? (!empty($from_location_other[$i]) ? htmlspecialchars($from_location_other[$i]) : null) 
                : htmlspecialchars($from_location[$i]);
            $toLocation = ($to_location[$i] === 'Other') 
                ? (!empty($to_location_other[$i]) ? htmlspecialchars($to_location_other[$i]) : null) 
                : htmlspecialchars($to_location[$i]);
            $distanceValue = !empty($distance[$i]) ? htmlspecialchars($distance[$i]) : null;
            $nightValue = (!empty($nights[$i]) || $nights[$i] === "0") ? htmlspecialchars($nights[$i]) : 0;

            $stmt = $pdo->prepare('INSERT INTO supervision_mapping (lecturer_id, date_of_supervision, student_name, index_number, from_location, to_location, distance, nights, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)');
            $stmt->execute([
                $lecturerId,
                htmlspecialchars($date_of_supervision[$i]),
                htmlspecialchars($student_name[$i]),
                htmlspecialchars($index_number[$i]),
                $fromLocation,
                $toLocation,
                $distanceValue,
                $nightValue,
                $status
            ]);
        }
    }

    if (isset($_POST['save'])) {
        header("Location: mapping.php?success=save");
        exit;
    } elseif (isset($_POST['submit'])) {
        // Mark mapping as submitted
        $stmt = $pdo->prepare('UPDATE lecturer_login SET mapping_submitted = 1 WHERE id = ?');
        $stmt->execute([$lecturerId]);
        header("Location: mapping.php?success=submit");
        exit;
    }
}

// Display success message if redirected
if (isset($_GET['success'])) {
    if ($_GET['success'] === 'save') {
        $successMessage = "Data saved successfully!";
    } elseif ($_GET['success'] === 'submit') {
        $successMessage = "Data submitted successfully!";
    }
}

// Check if mapping has been submitted
$stmt = $pdo->prepare('SELECT mapping_submitted FROM lecturer_login WHERE id = ?');
$stmt->execute([$lecturerId]);
$mappingSubmitted = $stmt->fetchColumn();

// Fetch assigned students' details along with their index numbers from the users table
$stmt = $pdo->prepare('
    SELECT sd.id, sd.first_name, sd.surname, u.index_number, sd.organisation_name 
    FROM student_details sd 
    JOIN users u ON sd.user_id = u.id
    WHERE sd.lecturer_id = ?
');
$stmt->execute([$lecturerId]);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch existing supervision data
$stmt = $pdo->prepare('SELECT * FROM supervision_mapping WHERE lecturer_id = ?');
$stmt->execute([$lecturerId]);
$supervisionData = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Supervision Mapping</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
      body {
        background-color: #f8f9fa;
      }
      /* Mobile Warning Overlay */
      #mobileWarning {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.8);
        color: #fff;
        display: none;
        align-items: center;
        justify-content: center;
        text-align: center;
        padding: 20px;
        z-index: 9999;
        flex-direction: column;
      }
      #mobileWarning h2 {
        font-size: 2rem;
        margin-bottom: 10px;
      }
      #mobileWarning p {
        font-size: 1.2rem;
      }
    </style>
  </head>
  <body>
    <!-- Mobile Warning Overlay -->
    <div id="mobileWarning">
      <div>
        <h2>Desktop Only</h2>
        <p>This page is only available on desktop screens.<br>Please use a laptop or desktop to view this page.</p>
        <!-- Redirect to index page when user clicks "Okay" -->
        <button type="button" class="btn btn-light mt-3" onclick="redirectToIndex()">Okay</button>
      </div>
    </div>
    
    <div class="container mt-4" id="mainContent">
      <h2>Supervision Data</h2>
      <?php if ($successMessage): ?>
        <!-- Success Modal (optional) -->
        <div class="modal fade" id="successModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="successModalLabel">Success</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <?php echo $successMessage; ?>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
              </div>
            </div>
          </div>
        </div>
      <?php endif; ?>

      <?php if ($mappingSubmitted): ?>
        <p>The mapping has been submitted and cannot be edited.</p>
      <?php else: ?>
        <form id="supervisionForm" method="POST">
          <div class="table-responsive">
            <table class="table table-striped">
              <thead>
                <tr>
                  <th>Date of Supervision</th>
                  <th>Student Name</th>
                  <th>Index Number</th>
                  <th>From</th>
                  <th>To</th>
                  <th>Distance (KM)</th>
                  <th>Nights</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody id="supervisionTableBody">
                <?php foreach ($supervisionData as $data): ?>
                  <tr data-id="<?php echo $data['id']; ?>">
                    <td><input type="date" name="date_of_supervision[]" value="<?php echo htmlspecialchars($data['date_of_supervision']); ?>" class="form-control" required></td>
                    <td>
                      <select name="student_name[]" class="form-control">
                        <option value="">Select Student</option>
                        <?php foreach ($students as $student): ?>
                          <option value="<?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?>" 
                                  data-index="<?php echo htmlspecialchars($student['index_number']); ?>" 
                                  <?php echo ($data['student_name'] == $student['first_name'] . ' ' . $student['surname']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?>
                          </option>
                        <?php endforeach; ?>
                        <option value="Other" <?php echo (is_null($data['student_name'])) ? 'selected' : ''; ?>>Other</option>
                      </select>
                    </td>
                    <td><input type="text" name="index_number[]" value="<?php echo htmlspecialchars($data['index_number']); ?>" class="form-control" readonly></td>
                    <td>
                      <select name="from_location[]" class="form-control from-location-select">
                        <?php foreach ($students as $student): ?>
                          <option value="<?php echo htmlspecialchars($student['organisation_name']); ?>" 
                                  <?php echo ($data['from_location'] == $student['organisation_name']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($student['organisation_name']); ?>
                          </option>
                        <?php endforeach; ?>
                        <option value="Other" <?php echo (!in_array($data['from_location'], array_column($students, 'organisation_name'))) ? 'selected' : ''; ?>>Other</option>
                      </select>
                      <input type="text" name="from_location_other[]" class="form-control from-location-other" style="<?php echo (!in_array($data['from_location'], array_column($students, 'organisation_name'))) ? '' : 'display: none;'; ?>" value="<?php echo htmlspecialchars($data['from_location']); ?>" placeholder="Enter other location">
                    </td>
                    <td>
                      <select name="to_location[]" class="form-control to-location-select">
                        <?php foreach ($students as $student): ?>
                          <option value="<?php echo htmlspecialchars($student['organisation_name']); ?>" 
                                  <?php echo ($data['to_location'] == $student['organisation_name']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($student['organisation_name']); ?>
                          </option>
                        <?php endforeach; ?>
                        <option value="Other" <?php echo (!in_array($data['to_location'], array_column($students, 'organisation_name'))) ? 'selected' : ''; ?>>Other</option>
                      </select>
                      <input type="text" name="to_location_other[]" class="form-control to-location-other" style="<?php echo (!in_array($data['to_location'], array_column($students, 'organisation_name'))) ? '' : 'display: none;'; ?>" value="<?php echo htmlspecialchars($data['to_location']); ?>" placeholder="Enter other location">
                    </td>
                    <td><input type="number" step="0.1" name="distance[]" value="<?php echo htmlspecialchars($data['distance']); ?>" class="form-control distance" required></td>
                    <td><input type="number" name="nights[]" value="<?php echo htmlspecialchars($data['nights']); ?>" class="form-control nights" required></td>
                    <td><button type="button" class="btn btn-danger remove-row" data-id="<?php echo $data['id']; ?>">Remove</button></td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <button type="button" class="btn btn-primary" id="addRow">Add Row</button>
          <button type="submit" name="save" class="btn btn-success">Save</button>
          <button type="submit" name="submit" class="btn btn-primary">Submit</button>
        </form>
      <?php endif; ?>
      <div class="mt-3">
        <p><strong>Total Distance (KM):</strong> <span id="totalDistance">0</span></p>
        <p><strong>Total Nights:</strong> <span id="totalNights">0</span></p>
      </div>
      <!-- Download Dropdown -->
      <div class="mt-3 d-flex justify-content-between">
        <div class="btn-group">
          <button type="button" class="btn btn-outline-custom dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
            Download
          </button>
          <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="download_pdf.php">PDF</a></li>
            <li><a class="dropdown-item" href="export_excel.php">Excel</a></li>
          </ul>
        </div>
      </div>
    </div>

    <!-- Mobile-Friendly Adjustments -->
    <style>
      @media (max-width: 576px) {
        .container {
          padding: 0 10px;
        }
        h2 {
          font-size: 1.5rem;
        }
        h3 {
          font-size: 1.25rem;
        }
        .btn {
          font-size: 0.9rem;
          padding: 0.5rem 0.8rem;
        }
        .form-control, .table {
          font-size: 0.9rem;
        }
        .table-responsive {
          overflow-x: auto;
        }
      }
    </style>

    <script>
      // Restrict page to desktop only
      function checkScreenSize() {
          if (window.innerWidth < 992) {
              document.getElementById("mobileWarning").style.display = "flex";
              document.getElementById("mainContent").style.filter = "blur(5px)";
          } else {
              document.getElementById("mobileWarning").style.display = "none";
              document.getElementById("mainContent").style.filter = "none";
          }
      }
      window.addEventListener("load", checkScreenSize);
      window.addEventListener("resize", checkScreenSize);

      // Redirect user to index page when "Okay" is clicked on mobile overlay
      function redirectToIndex() {
          window.location.href = "index.php";
      }

      // Multi-step form pagination
      var currentStep = 1;
      var totalSteps = 3;
      
      function showStep(step) {
          var steps = document.getElementsByClassName('step');
          for (var i = 0; i < steps.length; i++) {
              steps[i].classList.remove('active');
          }
          document.getElementById('step-' + step).classList.add('active');
          
          document.getElementById('stepIndicator').innerText = "Step " + step + " of " + totalSteps;
          var progressPercent = (step / totalSteps) * 100;
          document.getElementById('progressBar').style.width = progressPercent + "%";
          document.getElementById('progressBar').setAttribute("aria-valuenow", progressPercent);
      }
      
      function nextStep() {
          if (currentStep < totalSteps) {
              currentStep++;
              showStep(currentStep);
          }
      }
      
      function prevStep() {
          if (currentStep > 1) {
              currentStep--;
              showStep(currentStep);
          }
      }
      
      document.addEventListener('DOMContentLoaded', function() {
          showStep(currentStep);
          setTimeout(function(){
              var saveAlert = document.getElementById('saveAlert');
              if (saveAlert) {
                  saveAlert.style.display = 'none';
              }
          }, 3000);
      });
      
      (function () {
        'use strict';
        var forms = document.querySelectorAll('.needs-validation');
        Array.prototype.slice.call(forms).forEach(function (form) {
          form.addEventListener('submit', function (event) {
            if (!form.checkValidity() && event.submitter.name === 'submit') {
              event.preventDefault();
              event.stopPropagation();
            }
            form.classList.add('was-validated');
          }, false);
        });
      })();

      // Additional code for dynamic row functionality...
      document.addEventListener('DOMContentLoaded', function() {
          // Add new row to the supervision table
          document.getElementById('addRow').addEventListener('click', function() {
              const row = document.createElement('tr');
              row.innerHTML = `
                  <td><input type="date" name="date_of_supervision[]" class="form-control" required></td>
                  <td>
                      <select name="student_name[]" class="form-control">
                          <option value="">Select Student</option>
                          <?php foreach ($students as $student): ?>
                              <option value="<?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?>" data-index="<?php echo htmlspecialchars($student['index_number']); ?>">
                                  <?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname']); ?>
                              </option>
                          <?php endforeach; ?>
                          <option value="Other">Other</option>
                      </select>
                  </td>
                  <td><input type="text" name="index_number[]" class="form-control" readonly></td>
                  <td>
                      <select name="from_location[]" class="form-control from-location-select">
                          <?php foreach ($students as $student): ?>
                              <option value="<?php echo htmlspecialchars($student['organisation_name']); ?>">
                                  <?php echo htmlspecialchars($student['organisation_name']); ?>
                              </option>
                          <?php endforeach; ?>
                          <option value="Other">Other</option>
                      </select>
                      <input type="text" name="from_location_other[]" class="form-control from-location-other" style="display: none;" placeholder="Enter other location">
                  </td>
                  <td>
                      <select name="to_location[]" class="form-control to-location-select">
                          <?php foreach ($students as $student): ?>
                              <option value="<?php echo htmlspecialchars($student['organisation_name']); ?>">
                                  <?php echo htmlspecialchars($student['organisation_name']); ?>
                              </option>
                          <?php endforeach; ?>
                          <option value="Other">Other</option>
                      </select>
                      <input type="text" name="to_location_other[]" class="form-control to-location-other" style="display: none;" placeholder="Enter other location">
                  </td>
                  <td><input type="number" step="0.1" name="distance[]" class="form-control distance" required></td>
                  <td><input type="number" name="nights[]" class="form-control nights" required></td>
                  <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
              `;
              document.getElementById('supervisionTableBody').appendChild(row);
              bindLocationSelect(row);
              updateTotals();
          });

          // Remove row
          document.addEventListener('click', function(e) {
              if (e.target && e.target.classList.contains('remove-row')) {
                  if (confirm('Are you sure you want to remove this row?')) {
                      const row = e.target.closest('tr');
                      row.remove();
                      updateTotals();
                  }
              }
          });

          // Bind location select change for dynamic rows
          function bindLocationSelect(row) {
              row.querySelectorAll('.from-location-select, .to-location-select').forEach(select => {
                  select.addEventListener('change', function() {
                      const otherInput = this.nextElementSibling;
                      if (this.value === 'Other') {
                          otherInput.style.display = 'block';
                          otherInput.required = true;
                      } else {
                          otherInput.style.display = 'none';
                          otherInput.required = false;
                      }
                  });
              });
          }

          // Update totals for distance and nights
          function updateTotals() {
              let totalDistance = 0;
              let totalNights = 0;
              document.querySelectorAll('.distance').forEach(input => {
                  totalDistance += parseFloat(input.value) || 0;
              });
              document.querySelectorAll('.nights').forEach(input => {
                  totalNights += parseInt(input.value) || 0;
              });
              document.getElementById('totalDistance').textContent = totalDistance.toFixed(2);
              document.getElementById('totalNights').textContent = totalNights;
          }
          updateTotals();
      });
    </script>
  </body>
</html>
<?php include 'lect_footer.php'; ?>
<?php ob_end_flush(); ?>
