<?php
ob_start();
session_start();

// If not logged in, redirect
if (!isset($_SESSION['lecturer_id'])) {
    header('Location: login.php');
    exit;
}

// Database connection
include '../config/database.php';

// Get lecturer info
$lecturer_id = $_SESSION['lecturer_id'] ?? '';
$lecturer_first_name = '';
$smsSent = 0;

if ($lecturer_id) {
    $stmt = $pdo->prepare('SELECT name, sms_sent FROM lecturer_login WHERE id = ?');
    $stmt->execute([$lecturer_id]);
    $lecturer = $stmt->fetch();
    if ($lecturer) {
        $fullName = $lecturer['name'];
        $lecturer_first_name = htmlspecialchars(explode(' ', $fullName)[0], ENT_QUOTES, 'UTF-8');
        $smsSent = (int) $lecturer['sms_sent'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Supervision Mapping</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Favicon -->
  <link rel="icon" type="image/png" href="../public/img/sob_logo.png">

  <!-- Font Awesome -->
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css"
  >

  <!-- Bootstrap 5 CSS -->
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css"
    rel="stylesheet"
  >

  <!-- Your custom CSS -->
  <link href="style.css" rel="stylesheet">

  <style>
    .modal-header {
      background-color: #002047;
      color: white;
    }
    .btn-custom-send {
      background-color: #002047;
      color: white;
    }
    .btn-custom-send:hover {
      background-color: #001533;
      color: white;
    }

    /* Basic body styling */
    body {
      background-color: #f8f9fa;
    }

    /* For demonstration: hide or show .desktopView & .mobileView based on screen size */
    #desktopView { display: block; }
    #mobileView { display: none; }

    @media (max-width: 768px) {
      #desktopView { display: none; }
      #mobileView { display: block; }
      .card { border-radius: 0 !important; }
    }

    @media print {
      .d-print-none { display: none !important; }
    }

    @media (max-width: 576px) {
      .container {
        padding: 0 10px;
      }
      h2 {
        font-size: 1.5rem;
      }
      h3 {
        font-size: 1.25rem;
      }
      .btn {
        font-size: 0.9rem;
        padding: 0.5rem 1rem;
      }
      .card {
        font-size: 0.9rem;
        border-radius: 0 !important;
      }
      .table-responsive {
        overflow-x: auto;
      }
    }
  </style>
</head>

<body>

<!-- NAVBAR -->
<nav class="navbar navbar-expand-lg navbar-dark" style="background-color: #002047;">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="#">
      <img src="../public/img/sob_logo.png" alt="Logo" width="30" height="30" class="d-inline-block align-top">
      Lecturer Portal
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
            aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarNav">
      <?php if (!empty($lecturer_id)): ?>
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link" href="index">Students</a></li>
        <li class="nav-item"><a class="nav-link" href="region">Region</a></li>
        <li class="nav-item"><a class="nav-link" href="mapping">Mapping</a></li>
        <li class="nav-item"><a class="nav-link" href="results">Results</a></li>
        <li class="nav-item">
          <a class="nav-link" href="#" data-bs-toggle="modal" data-bs-target="#messageModal">Message</a>
        </li>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
             data-bs-toggle="dropdown" aria-expanded="false">
            <?php echo $lecturer_first_name; ?>
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
            <li><a class="dropdown-item" href="logout.php">Logout</a></li>
          </ul>
        </li>
      </ul>
      <?php endif; ?>
    </div>
  </div>
</nav>

<!-- MAIN CONTENT - with extra bottom margin to avoid "touching" footer -->
<div class="container mt-4 mb-5" id="mainContent">

  <!-- Success/Error Alerts -->
  <?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  <?php endif; ?>

  <?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
      <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  <?php endif; ?>

  <?php
  // Fetch assigned students
  $stmt = $pdo->prepare('
      SELECT sd.id, sd.first_name, sd.surname, u.index_number, sd.telephone, sd.organisation_name, 
             sd.location, sd.district, sd.region, sd.gps_location 
      FROM student_details sd
      JOIN users u ON sd.user_id = u.id
      WHERE sd.lecturer_id = ?
  ');
  $stmt->execute([$lecturer_id]);
  $students = $stmt->fetchAll(PDO::FETCH_ASSOC);
  ?>

  <h2>Assigned Students</h2>
  <?php if (empty($students)): ?>
    <div class="alert alert-info" role="alert">
      You have not been assigned any students yet.
    </div>
  <?php else: ?>
    <!-- Desktop View: Table -->
    <div id="desktopView">
      <div id="printHeader" class="d-none">
        <h3>Students assigned to <?php echo htmlspecialchars($fullName ?? '', ENT_QUOTES, 'UTF-8'); ?></h3>
      </div>
      <div class="table-responsive">
        <table class="table table-striped" id="studentsTable">
          <thead>
            <tr>
              <th>No.</th>
              <th>Name</th>
              <th>Index Number</th>
              <th>Telephone Number</th>
              <th>Name of Organisation</th>
              <th>Location</th>
              <th>District/Region</th>
              <th>GPS Location</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($students as $index => $student): ?>
            <tr>
              <td><?php echo $index + 1; ?></td>
              <td><?php echo htmlspecialchars($student['first_name'] . ' ' . $student['surname'], ENT_QUOTES, 'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars($student['index_number'], ENT_QUOTES, 'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars($student['telephone'], ENT_QUOTES, 'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars($student['organisation_name'], ENT_QUOTES, 'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars($student['location'], ENT_QUOTES, 'UTF-8'); ?></td>
              <td>
                <?php 
                  echo htmlspecialchars(
                    $student['district'] . '/' . substr($student['region'], 0, 2),
                    ENT_QUOTES,
                    'UTF-8'
                  ); 
                ?>
              </td>
              <td><?php echo htmlspecialchars($student['gps_location'], ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <button 
        class="btn btn-outline-custom d-print-none" 
        id="sendSmsButton"
        <?php echo $smsSent ? 'disabled' : ''; ?>
      >
        Send Bulk SMS
      </button>
      <button class="btn btn-outline-custom d-print-none" id="printButton">Print</button>
    </div>

    <!-- Mobile View: Accordion -->
    <div id="mobileView">
      <div class="accordion" id="accordionStudents">
        <?php foreach ($students as $index => $student):
          $collapseId = "collapse" . $index;
          $headingId = "heading" . $index;
        ?>
        <div class="accordion-item">
          <h2 class="accordion-header" id="<?php echo $headingId; ?>">
            <button 
              class="accordion-button <?php echo $index !== 0 ? 'collapsed' : ''; ?>"
              type="button" 
              data-bs-toggle="collapse" 
              data-bs-target="#<?php echo $collapseId; ?>"
              aria-expanded="<?php echo $index === 0 ? 'true' : 'false'; ?>"
              aria-controls="<?php echo $collapseId; ?>"
            >
              <?php
                echo htmlspecialchars($student['first_name'] . ' ' . $student['surname'], ENT_QUOTES, 'UTF-8')
                     . ' ('
                     . htmlspecialchars($student['index_number'], ENT_QUOTES, 'UTF-8')
                     . ')';
              ?>
            </button>
          </h2>
          <div
            id="<?php echo $collapseId; ?>"
            class="accordion-collapse collapse <?php echo $index === 0 ? 'show' : ''; ?>"
            aria-labelledby="<?php echo $headingId; ?>"
            data-bs-parent="#accordionStudents"
          >
            <div class="accordion-body">
              <p><strong>Telephone:</strong> <?php echo htmlspecialchars($student['telephone'], ENT_QUOTES, 'UTF-8'); ?></p>
              <p><strong>Organisation:</strong> <?php echo htmlspecialchars($student['organisation_name'], ENT_QUOTES, 'UTF-8'); ?></p>
              <p><strong>Location:</strong> <?php echo htmlspecialchars($student['location'], ENT_QUOTES, 'UTF-8'); ?></p>
              <p><strong>District/Region:</strong> 
                <?php echo htmlspecialchars(
                  $student['district'] . '/' . substr($student['region'], 0, 2),
                  ENT_QUOTES,
                  'UTF-8'
                ); ?>
              </p>
              <p><strong>GPS:</strong> <?php echo htmlspecialchars($student['gps_location'], ENT_QUOTES, 'UTF-8'); ?></p>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
      <div class="d-flex justify-content-between mt-3">
        <button
          class="btn btn-outline-custom"
          id="sendSmsButtonMobile"
          <?php echo $smsSent ? 'disabled' : ''; ?>
        >
          Send Bulk SMS
        </button>
      </div>
    </div>
  <?php endif; ?>
</div><!-- /.container with mb-5 -->

<!-- FOOTER (no mt-auto, so it won’t hug content) -->
<footer class="footer py-3" style="background: #002047;">
  <div class="container text-center">
    <span class="text-white">© 2024 Lecturer Portal. All rights reserved.</span>
  </div>
</footer>

<!-- SEND MESSAGE MODAL -->
<div class="modal fade" id="messageModal" tabindex="-1" aria-labelledby="messageModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="messageModalLabel">Send Message</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="POST" action="send_message.php">
        <div class="modal-body">
          <div class="mb-3">
            <label for="recipients" class="form-label">Recipients</label>
            <select multiple class="form-control" id="recipients" name="recipients[]">
              <?php
              // Populate recipients from assigned students
              $stmt = $pdo->prepare('
                SELECT user_id, CONCAT(first_name, " ", surname) AS name 
                FROM student_details 
                WHERE lecturer_id = ?
              ');
              $stmt->execute([$lecturer_id]);
              $assigned = $stmt->fetchAll(PDO::FETCH_ASSOC);
              foreach ($assigned as $stud) {
                  echo "<option value=\"{$stud['user_id']}\">" 
                       . htmlspecialchars($stud['name'], ENT_QUOTES, 'UTF-8')
                       . "</option>";
              }
              ?>
            </select>
          </div>
          <div class="form-check mb-3">
            <input type="checkbox" class="form-check-input" id="sendToAll" name="send_to_all" value="1">
            <label class="form-check-label" for="sendToAll">Send to all students</label>
          </div>
          <div class="mb-3">
            <label for="subject" class="form-label">Subject</label>
            <input type="text" class="form-control" id="subject" name="subject" required>
          </div>
          <div class="mb-3">
            <label for="message" class="form-label">Message</label>
            <textarea class="form-control" id="message" name="message" rows="3" required></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-custom-send">Send</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- JS SCRIPTS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script
  src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js">
</script>
<script
  src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js">
</script>

<script>
  // Handle 'Send to all' checkbox
  $(document).ready(function() {
    $('#sendToAll').on('change', function() {
      if ($(this).is(':checked')) {
        $('#recipients option').prop('selected', true);
      } else {
        $('#recipients option').prop('selected', false);
      }
    });
  });

  // Example SMS button (desktop)
  document.getElementById('sendSmsButton')?.addEventListener('click', function() {
    alert('SMS modal would appear here (desktop view).');
  });

  // Example SMS button (mobile)
  document.getElementById('sendSmsButtonMobile')?.addEventListener('click', function() {
    alert('SMS modal would appear here (mobile view).');
  });

  // Print button
  document.getElementById('printButton')?.addEventListener('click', function() {
    window.print();
  });
</script>

</body>
</html>
<?php ob_end_flush(); ?>
