<?php
include '../config/database.php';

if (isset($_GET['lecturer_id'])) {
    $lecturerId = htmlspecialchars($_GET['lecturer_id'], ENT_QUOTES, 'UTF-8');

    $stmt = $pdo->prepare('SELECT district FROM lecturer_assigned_districts WHERE lecturer_id = ?');
    $stmt->execute([$lecturerId]);
    $assignedDistricts = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Protecting the output in case it contains any special characters
    foreach ($assignedDistricts as &$district) {
        $district['district'] = htmlspecialchars($district['district'], ENT_QUOTES, 'UTF-8');
    }

    echo json_encode($assignedDistricts);
}
?>
