<?php
require_once '../includes/functions.php';
require_once '../config/database.php';

// Define secret key used for hashing (same as in functions.php)
$secret_key = 'my_secret_key';

try {
    // Prepare a SQL statement to select all audit logs
    $stmt = $pdo->prepare('SELECT id, user_id, username, action, affected_table, affected_id, timestamp, ip_address, user_agent, changes, signature, hash, is_tampered FROM audit_log');
    $stmt->execute();
    $logs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Loop through each log entry and verify its integrity
    foreach ($logs as $row) {
        // Recreate the log data string for hashing
        $log_data = $row['user_id'] . "|" . $row['username'] . "|" . $row['action'] . "|" . $row['affected_table'] . "|" . $row['affected_id'] . "|" . 
                    $row['timestamp'] . "|" . $row['ip_address'] . "|" . $row['user_agent'] . "|" . $row['changes'] . "|" . $row['signature'];

        // Recalculate the hash
        $recalculated_hash = hash_hmac('sha256', $log_data, $secret_key);

        // Compare stored hash with recalculated hash to check integrity
        if ($recalculated_hash !== $row['hash']) {
            // Mark the log as tampered
            $update_stmt = $pdo->prepare('UPDATE audit_log SET is_tampered = 1 WHERE id = ?');
            $update_stmt->execute([$row['id']]);

            // Send alert to admin
            $admin_email = "ayirebiacquahebenezer2@gmail.com";
            $subject = "Audit Log Tampering Detected";
            $message = "Tampering has been detected in the audit log entry ID: " . $row['id'];
            mail($admin_email, $subject, $message);
        }
    }

    echo "Audit log verification completed.";
} catch (Exception $e) {
    // Handle exceptions and errors
    echo "Error: " . $e->getMessage();
}
?>
