<?php
session_start();
include '../config/database.php';

// Check if system admin is logged in
if (!isset($_SESSION['sys_admin_id'])) {
    header('Location: login.php');
    exit;
}

$errorMessage = ''; 
$successMessage = ''; 
$excludedTables = ['sys_admin', 'districts'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['sys_admin_password'])) {
    $enteredPassword = $_POST['sys_admin_password'];

    // Fetch the system admin details to verify the password
    $stmt = $pdo->prepare('SELECT * FROM sys_admin WHERE id = :id');
    $stmt->bindParam(':id', $_SESSION['sys_admin_id']);
    $stmt->execute();
    $admin = $stmt->fetch();

    if ($admin && password_verify($enteredPassword, $admin['password'])) {
        try {
            $stmt = $pdo->query("SHOW TABLES");
            $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);

            if (!$pdo->inTransaction()) {
                $pdo->beginTransaction();
            }

            foreach ($tables as $table) {
                if (!in_array($table, $excludedTables)) {
                    $pdo->exec("SET FOREIGN_KEY_CHECKS=0");
                    $pdo->exec("TRUNCATE TABLE `$table`");
                    $pdo->exec("SET FOREIGN_KEY_CHECKS=1");
                }
            }

            if ($pdo->inTransaction()) {
                $pdo->commit();
            }

            $successMessage = 'Database cleaned successfully.';
        } catch (Exception $e) {
            if ($pdo->inTransaction()) {
                $pdo->rollBack();
            }
            $errorMessage = 'Failed to clean the database: ' . $e->getMessage();
        }
    } else {
        $errorMessage = 'Invalid system admin password.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Automated Database Cleaning</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            max-width: 600px;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .btn-clean {
            width: 100%;
            margin-top: 20px;
        }
        .btn-back {
            width: 100%;
            margin-top: 10px;
        }
        .loader {
            display: none; /* Ensure the loader is hidden by default */
            text-align: center;
            margin-top: 20px;
        }
        /* Loader styles */
        .loader-dots {
            display: inline-block;
        }
        .loader-dot {
            width: 10px;
            height: 10px;
            background-color: #08AEE0;
            border-radius: 50%;
            display: inline-block;
            animation: bounce 0.6s infinite alternate;
        }
        .loader-dot:nth-child(2) {
            animation-delay: 0.2s;
        }
        .loader-dot:nth-child(3) {
            animation-delay: 0.4s;
        }
        @keyframes bounce {
            to {
                transform: translateY(-10px);
            }
        }
    </style>
</head>
<body>

<!-- Loader Section -->
<div id="loader" class="loader">
    <div class="loader-dots">
        <div class="loader-dot"></div>
        <div class="loader-dot"></div>
        <div class="loader-dot"></div>
    </div>
    <div class="loader-text">Please wait...</div>
</div>

<div class="container">
    <h2>Automated Database Cleaning</h2>

    <!-- Display Error Messages -->
    <?php if (!empty($errorMessage)): ?>
        <div class="alert alert-danger text-center" role="alert">
            <?php echo htmlspecialchars($errorMessage); ?>
        </div>
    <?php endif; ?>

    <!-- Display Success Messages -->
    <?php if (!empty($successMessage)): ?>
        <div class="alert alert-success text-center" role="alert">
            <?php echo htmlspecialchars($successMessage); ?>
        </div>
    <?php endif; ?>

    <!-- Excluded Tables Information -->
    <div class="alert alert-warning text-center">
        Note: The following tables have been excluded from cleaning: <strong><?php echo implode(', ', $excludedTables); ?></strong>.
    </div>

    <!-- Clean Database Button -->
    <button type="button" class="btn btn-danger btn-clean" data-bs-toggle="modal" data-bs-target="#passwordModal">Clean Database</button>

    <!-- Back to Dashboard Button -->
    <a href="index.php" class="btn btn-primary btn-back">Back to Dashboard</a>
</div>

<!-- Modal for sys_admin password -->
<div class="modal fade" id="passwordModal" tabindex="-1" aria-labelledby="passwordModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="passwordModalLabel">Enter System Admin Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" onsubmit="showLoader()">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="sys_admin_password" class="form-label">Password</label>
                        <input type="password" class="form-control" id="sys_admin_password" name="sys_admin_password" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.getElementById('sys_admin_password').onpaste = function(e) {
        e.preventDefault();
        alert("Pasting is not allowed. Please type the password.");
    };

    function showLoader() {
        document.getElementById('loader').style.display = 'block'; // Show the loader when form is submitted
        document.querySelector('.container').style.display = 'none'; // Optionally hide the main container
    }
</script>
</body>
</html>
