<?php
session_start();
include('../config/database.php');

// Check if the system admin is logged in
if (!isset($_SESSION['sys_admin_id'])) {
    header('Location: ../status/login');
    exit;
}

// Query to fetch students with 'submitted' status, no acceptance letter, and corresponding index_number from users table
$query = "SELECT sd.*, u.index_number 
          FROM student_details sd 
          JOIN users u ON sd.user_id = u.id 
          WHERE sd.status = 'submitted' AND (sd.acceptance_letter IS NULL OR sd.acceptance_letter = '')";
$stmt = $pdo->prepare($query);
$stmt->execute();
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Handle the status update form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user_id'])) {
    $user_id = $_POST['user_id'];
    $update_query = "UPDATE student_details SET status = 'saved' WHERE user_id = :user_id";
    $update_stmt = $pdo->prepare($update_query);
    $update_stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
    $update_stmt->execute();

    // Redirect to the same page to refresh the list
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Submissions Without Letters</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f7fa;
            color: #333;
        }
        .container {
            max-width: 600px;
            padding: 2rem;
            margin-top: 2rem;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.05);
        }
        h2 {
            font-weight: 600;
            color: #4a4a4a;
            text-align: center;
            margin-bottom: 1.5rem;
        }
        .list-group-item {
            cursor: pointer;
            transition: background-color 0.2s;
        }
        .list-group-item:hover {
            background-color: #f1f1f1;
        }
        .back-btn {
            font-size: 14px;
            color: #007bff;
            text-decoration: none;
            margin-bottom: 15px;
            display: inline-block;
        }
    </style>
</head>
<body>
<div class="container">
    <a href="index" class="back-btn">← Back to Dashboard</a>
    <h2>Submissions Without Letters</h2>
    
    <?php if (count($results) > 0): ?>
        <ul class="list-group">
            <?php foreach ($results as $row): ?>
                <li class="list-group-item" data-bs-toggle="modal" data-bs-target="#studentModal-<?php echo $row['user_id']; ?>">
                    Index Number: <?php echo htmlspecialchars($row['index_number'], ENT_QUOTES, 'UTF-8'); ?> - 
                    <?php echo htmlspecialchars($row['first_name'], ENT_QUOTES, 'UTF-8'); ?> <?php echo htmlspecialchars($row['surname'], ENT_QUOTES, 'UTF-8'); ?>
                </li>

                <!-- Modal for student details -->
                <div class="modal fade" id="studentModal-<?php echo $row['user_id']; ?>" tabindex="-1" aria-labelledby="studentModalLabel-<?php echo $row['user_id']; ?>" aria-hidden="true">
                    <div class="modal-dialog modal-md"> <!-- Set modal to medium size with modal-md -->
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="studentModalLabel-<?php echo $row['user_id']; ?>">Student Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Index Number:</strong> <?php echo htmlspecialchars($row['index_number'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>First Name:</strong> <?php echo htmlspecialchars($row['first_name'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>Surname:</strong> <?php echo htmlspecialchars($row['surname'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>Other Names:</strong> <?php echo htmlspecialchars($row['other_names'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>Telephone:</strong> <?php echo htmlspecialchars($row['telephone'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>Email:</strong> <?php echo htmlspecialchars($row['email'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>Course:</strong> <?php echo htmlspecialchars($row['course'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>Group:</strong> <?php echo htmlspecialchars($row['group'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>Organisation Name:</strong> <?php echo htmlspecialchars($row['organisation_name'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>Months:</strong> <?php echo htmlspecialchars($row['months'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>Location:</strong> <?php echo htmlspecialchars($row['location'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>GPS Location:</strong> 
                                    <a href="<?php echo htmlspecialchars($row['gps_location'], ENT_QUOTES, 'UTF-8'); ?>" target="_blank">
                                        <?php echo htmlspecialchars($row['gps_location'], ENT_QUOTES, 'UTF-8'); ?>
                                    </a>
                                </p>
                                <p><strong>Region:</strong> <?php echo htmlspecialchars($row['region'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>District:</strong> <?php echo htmlspecialchars($row['district'], ENT_QUOTES, 'UTF-8'); ?></p>
                                <p><strong>Acceptance Letter:</strong> 
                                    <?php if (!empty($row['acceptance_letter'])): ?>
                                        <a href="../uploads/<?php echo htmlspecialchars($row['acceptance_letter'], ENT_QUOTES, 'UTF-8'); ?>" target="_blank">View Letter</a>
                                    <?php else: ?>
                                        No letter added
                                    <?php endif; ?>
                                </p>
                                <p><strong>Status:</strong> <?php echo htmlspecialchars($row['status'], ENT_QUOTES, 'UTF-8'); ?></p>
                            </div>
                            <div class="modal-footer">
                                <form method="post" action="">
                                    <input type="hidden" name="user_id" value="<?php echo $row['user_id']; ?>">
                                    <button type="submit" class="btn btn-primary">Return</button>
                                </form>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </ul>
    <?php else: ?>
        <div class="alert alert-info text-center">No students found with a 'submitted' status and without an acceptance letter.</div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
