<?php
session_start();
include '../config/database.php';

if (!isset($_SESSION['sys_admin_id'])) {
    header('Location: login');
    exit;
}

$stmt = $pdo->prepare('SELECT * FROM sys_admin WHERE id = :id');
$stmt->bindParam(':id', $_SESSION['sys_admin_id']);
$stmt->execute();
$admin = $stmt->fetch();

if (!$admin) {
    header('Location: login');
    exit;
}

$successMessage = '';
$errorMessage = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_admin'])) {
    $username = htmlspecialchars($_POST['username'], ENT_QUOTES, 'UTF-8');
    $password = htmlspecialchars($_POST['password'], ENT_QUOTES, 'UTF-8');
    $confirmPassword = htmlspecialchars($_POST['confirm_password'], ENT_QUOTES, 'UTF-8');

    if ($password !== $confirmPassword) {
        $errorMessage = 'Passwords do not match.';
    } else {
        $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

        if (!empty($username) && !empty($password)) {
            try {
                $stmt = $pdo->prepare('SELECT COUNT(*) FROM admins WHERE username = :username');
                $stmt->bindParam(':username', $username);
                $stmt->execute();
                $exists = $stmt->fetchColumn();

                if ($exists) {
                    $errorMessage = 'Username already exists. Please choose another.';
                } else {
                    $stmt = $pdo->prepare('INSERT INTO admins (username, password) VALUES (:username, :password)');
                    $stmt->bindParam(':username', $username);
                    $stmt->bindParam(':password', $hashedPassword);
                    $stmt->execute();
                    $successMessage = 'Admin account created successfully.';
                }
            } catch (Exception $e) {
                $errorMessage = 'Error creating admin account: ' . $e->getMessage();
            }
        } else {
            $errorMessage = 'Both username and password are required.';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f0f2f5;
            font-family: 'Poppins', sans-serif;
            color: #333;
        }
        .navbar {
            background-color: #333;
            padding: 15px;
        }
        .navbar-brand {
            color: #fff;
            font-weight: bold;
            font-size: 20px;
            text-decoration: none;
        }
        .navbar .btn {
            color: #fff;
        }
        .container {
            max-width: 900px;
            margin: 50px auto;
            background: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #333;
            font-weight: 700;
            margin-bottom: 20px;
            font-size: 28px;
        }
        .card {
            border: none;
            background: #f9f9f9;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0px 5px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0px 10px 20px rgba(0, 0, 0, 0.15);
        }
        .card i {
            font-size: 36px;
            color: #007bff;
        }
        .card-title {
            font-size: 18px;
            font-weight: bold;
            margin: 15px 0;
        }
        .btn-outline-primary {
            border: 2px solid #007bff;
            color: #007bff;
            border-radius: 5px;
            padding: 10px 20px;
            transition: background 0.3s ease, color 0.3s ease;
        }
        .btn-outline-primary:hover {
            background: #007bff;
            color: #fff;
        }
        /* Disabled button styling */
        .btn-disabled {
            border-color: #ccc;
            color: #ccc;
            pointer-events: none;
            cursor: not-allowed;
        }
        .modal-header {
            background-color: #007bff;
            color: #fff;
        }
    </style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg">
    <a class="navbar-brand" href="#"><i class="fas fa-tools"></i> Admin Dashboard</a>
    <div class="ms-auto">
        <a href="logout.php" class="btn btn-link"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>
</nav>

<div class="container">
    <h2>Welcome, <?php echo htmlspecialchars($admin['username'], ENT_QUOTES, 'UTF-8'); ?></h2>

    <div class="row row-cols-1 row-cols-md-3 g-4">
        <div class="col">
            <div class="card">
                <i class="fas fa-user-plus"></i>
                <h5 class="card-title">Create Admin Account</h5>
                <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#createAdminModal">Create Admin</button>
            </div>
        </div>
        
        <!-- System Reset card with disabled button -->
        <div class="col">
            <div class="card">
                <i class="fas fa-sync-alt"></i>
                <h5 class="card-title">System Reset</h5>
                <button class="btn btn-outline-primary btn-disabled">Reset System</button>
            </div>
        </div>

        <div class="col">
            <div class="card">
                <i class="fas fa-clipboard-list"></i>
                <h5 class="card-title">View Audit Log</h5>
                <a href="view_audit_log" class="btn btn-outline-primary">View Audit</a>
            </div>
        </div>
        <div class="col">
            <div class="card">
                <i class="fas fa-broom"></i>
                <h5 class="card-title">Clean Data</h5>
                <a href="clean_student_data" class="btn btn-outline-primary">Clean Data</a>
            </div>
        </div>
        <div class="col">
            <div class="card">
                <i class="fas fa-check-circle"></i>
                <h5 class="card-title">Complete Submissions</h5>
                <a href="complete_submission" class="btn btn-outline-primary">Complete Submissions</a>
            </div>
        </div>
        <div class="col">
            <div class="card">
                <i class="fas fa-search"></i>
                <h5 class="card-title">View/Search Student Details</h5>
                <a href="search_students" class="btn btn-outline-primary">Search Students</a>
            </div>
        </div>
        <div class="col">
            <div class="card">
                <i class="fas fa-folder-open"></i>
                <h5 class="card-title">Manage Submissions</h5>
                <a href="submissions_without_letters" class="btn btn-outline-primary">Manage Submissions</a>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Creating Admin -->
<div class="modal fade" id="createAdminModal" tabindex="-1" aria-labelledby="createAdminModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createAdminModalLabel">Create New Admin</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <?php if (!empty($successMessage)): ?>
                        <div class="alert alert-success"><?php echo htmlspecialchars($successMessage); ?></div>
                    <?php endif; ?>
                    <?php if (!empty($errorMessage)): ?>
                        <div class="alert alert-danger"><?php echo htmlspecialchars($errorMessage); ?></div>
                    <?php endif; ?>
                    <div class="mb-3">
                        <label for="username" class="form-label">Username</label>
                        <input type="text" name="username" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">Password</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Confirm Password</label>
                        <input type="password" name="confirm_password" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" name="create_admin" class="btn btn-primary">Create Admin</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
