<?php
session_start();
include '../config/database.php'; // This file contains the PDO connection

// Check if system admin is logged in
if (!isset($_SESSION['sys_admin_id'])) {
    header('Location: login.php');
    exit;
}

$successMessage = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['clean_data'])) {
    // Function to apply 'PROPER' functionality (capitalize the first letter of each word)
    function toProperCase($string) {
        return ucwords(strtolower(trim($string)));
    }

    try {
        // Query to fetch all student details
        $sql = "SELECT id, surname, first_name, other_names, organisation_name, location, region, district FROM student_details";
        $stmt = $pdo->query($sql);
        $students = $stmt->fetchAll();

        if ($students) {
            // Prepare the update query
            $updateStmt = $pdo->prepare("UPDATE student_details 
                                SET surname = :surname, 
                                    first_name = :first_name, 
                                    other_names = :other_names, 
                                    organisation_name = :organisation_name, 
                                    location = :location, 
                                    region = :region, 
                                    district = :district 
                                WHERE id = :id");

            // Loop through the result set
            foreach ($students as $student) {
                // Apply TRIM and PROPER functions to each relevant field
                $cleaned_surname = toProperCase($student['surname']);
                $cleaned_first_name = toProperCase($student['first_name']);
                $cleaned_other_names = toProperCase($student['other_names']);
                $cleaned_organisation_name = toProperCase($student['organisation_name']);
                $cleaned_location = toProperCase($student['location']);
                $cleaned_region = toProperCase($student['region']);
                $cleaned_district = toProperCase($student['district']);

                // Execute the update query
                $updateStmt->execute([
                    ':surname' => $cleaned_surname,
                    ':first_name' => $cleaned_first_name,
                    ':other_names' => $cleaned_other_names,
                    ':organisation_name' => $cleaned_organisation_name,
                    ':location' => $cleaned_location,
                    ':region' => $cleaned_region,
                    ':district' => $cleaned_district,
                    ':id' => $student['id']
                ]);
            }

            $successMessage = "Data cleaned successfully!";
        } else {
            $successMessage = "No records found.";
        }

    } catch (PDOException $e) {
        $successMessage = "Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: 'Helvetica Neue', sans-serif;
        }

        .container {
            max-width: 800px;
            margin-top: 50px;
            padding: 40px;
            background-color: #fff;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        h2 {
            font-weight: 400;
            text-align: center;
            margin-bottom: 40px;
        }

        .card {
            border: none;
            background-color: #f9f9f9;
            padding: 20px;
            transition: all 0.3s ease-in-out;
        }

        .card:hover {
            box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
            transform: translateY(-5px);
        }

        .btn-outline {
            border: 2px solid #007bff;
            color: #007bff;
            background-color: transparent;
            padding: 10px;
            font-size: 16px;
            border-radius: 0;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .btn-outline:hover {
            background-color: #007bff;
            color: #fff;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Welcome to the System Admin Dashboard</h2>

    <!-- Display Success Message -->
    <?php if (!empty($successMessage)): ?>
        <div class="alert alert-success text-center">
            <?php echo htmlspecialchars($successMessage, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>

    <!-- Button to trigger modal -->
    <div class="text-center">
        <button type="button" class="btn btn-outline" data-bs-toggle="modal" data-bs-target="#confirmModal">Clean Data</button>
    </div>

    <!-- Confirmation Modal -->
    <div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmModalLabel">Confirm Data Cleaning</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to clean all data in the database?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <form method="POST" style="display:inline;">
                        <button type="submit" name="clean_data" class="btn btn-outline-danger">Yes, Clean Data</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Back to Dashboard Button -->
    <div class="text-center mt-4">
        <a href="index.php" class="btn btn-outline-primary">Back to Dashboard</a>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
