<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include '../includes/header.php';
include '../config/database.php';

// Fetch the logged-in student's submission details
$userId = $_SESSION['user_id'];
$indexNumber = $_SESSION['index_number']; // Fetch the index number from the session
$stmt = $pdo->prepare('SELECT * FROM student_details WHERE user_id = ?');
$stmt->execute([$userId]);
$studentDetails = $stmt->fetch();

if (!$studentDetails) {
    echo "<div class='container mt-4'><h2>No submission found.</h2></div>";
    include '../includes/footer.php';
    exit;
}

$uploadDir = '../uploads/';
$acceptanceLetterPath = $uploadDir . htmlspecialchars(basename($studentDetails['acceptance_letter']));
?>

<div class="container mt-4 mb-5">
    <h2>Submission Summary</h2>
    <div class="card mb-4">
        <div class="card-header">
            <h3>Student's Details</h3>
        </div>
        <div class="card-body">
            <p><strong>Index Number:</strong> <?php echo htmlspecialchars($indexNumber); ?></p>
            <p><strong>Surname:</strong> <?php echo htmlspecialchars($studentDetails['surname']); ?></p>
            <p><strong>First Name:</strong> <?php echo htmlspecialchars($studentDetails['first_name']); ?></p>
            <p><strong>Other Names:</strong> <?php echo htmlspecialchars($studentDetails['other_names']); ?></p>
            <p><strong>Telephone Number:</strong> <?php echo htmlspecialchars($studentDetails['telephone']); ?></p>
            <p><strong>Email:</strong> <?php echo htmlspecialchars($studentDetails['email']); ?></p>
            <p><strong>Course of Study:</strong> <?php echo htmlspecialchars($studentDetails['course']); ?></p>
        </div>
    </div>
    <div class="card mb-4">
        <div class="card-header">
            <h3><?php echo htmlspecialchars($studentDetails['group']) === 'Industrial Internship' ? 'Organisation' : 'School'; ?> Details</h3>
        </div>
        <div class="card-body">
            <p><strong><?php echo htmlspecialchars($studentDetails['group']) === 'Industrial Internship' ? 'Name of Organisation' : 'Name of School'; ?>:</strong> <?php echo htmlspecialchars($studentDetails['organisation_name']); ?></p>
            <p><strong>Number of Months:</strong> <?php echo htmlspecialchars($studentDetails['months']); ?></p>
            <p><strong>Location:</strong> <?php echo htmlspecialchars($studentDetails['location']); ?></p>
            <p><strong>Ghana Post GPS/Google Location:</strong> <?php echo htmlspecialchars($studentDetails['gps_location']); ?></p>
            <p><strong>Region:</strong> <?php echo htmlspecialchars($studentDetails['region']); ?></p>
            <p><strong>District:</strong> <?php echo htmlspecialchars($studentDetails['district']); ?></p>
            <p><strong>Acceptance Letter:</strong> <a href="<?php echo $acceptanceLetterPath; ?>" target="_blank">View Letter</a></p>
        </div>
    </div>
    <div class="text-center my-4">
        <a href="../student/download_submission.php" class="btn btn-primary btn-lg">
            <i class="fas fa-download"></i> Download Proof
        </a>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
