<?php
ob_start(); // Start output buffering
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include '../includes/header.php';
include '../config/database.php';

// Fetch the current internship details of the student
$userId = $_SESSION['user_id'];
$stmt = $pdo->prepare('SELECT organisation_name, location, gps_location, district, region FROM student_details WHERE user_id = ?');
$stmt->execute([$userId]);
$currentDetails = $stmt->fetch(PDO::FETCH_ASSOC);

// Fetch the most recent approved transfer details if any
$stmt = $pdo->prepare('SELECT * FROM transfer_requests WHERE user_id = ? AND status = "approved" ORDER BY id DESC LIMIT 1');
$stmt->execute([$userId]);
$approvedTransfer = $stmt->fetch(PDO::FETCH_ASSOC);

// Fetch former organization details if any
$formerDetails = null;
if ($approvedTransfer) {
    $stmt = $pdo->prepare('SELECT * FROM former_organisations WHERE transfer_id = ? ORDER BY id DESC LIMIT 1');
    $stmt->execute([$approvedTransfer['id']]);
    $formerDetails = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Fetch regions from the database
$stmt = $pdo->prepare('SELECT DISTINCT region FROM districts');
$stmt->execute();
$regions = $stmt->fetchAll(PDO::FETCH_ASSOC);

$statusMessage = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize user inputs
    $newOrganisationName = htmlspecialchars($_POST['newOrganisationName']);
    $newLocation = htmlspecialchars($_POST['newLocation']);
    $newGpsLocation = htmlspecialchars($_POST['newGpsLocation']);
    $newRegion = htmlspecialchars($_POST['newRegion']);
    $newDistrict = htmlspecialchars($_POST['newDistrict']);
    $reason = htmlspecialchars($_POST['reason']);
    $filePath = '';

    if (isset($_FILES['acceptanceLetter']) && $_FILES['acceptanceLetter']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = '../uploads/';
        $fileName = $_SESSION['user_id'] . 'trns.' . pathinfo($_FILES['acceptanceLetter']['name'], PATHINFO_EXTENSION);
        $filePath = $uploadDir . $fileName;
        move_uploaded_file($_FILES['acceptanceLetter']['tmp_name'], $filePath);
    }

    $stmt = $pdo->prepare('INSERT INTO transfer_requests (user_id, new_organisation_name, new_location, new_gps_location, new_region, new_district, reason, acceptance_letter, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, "pending")');
    $stmt->execute([$userId, $newOrganisationName, $newLocation, $newGpsLocation, $newRegion, $newDistrict, $reason, $fileName]);

    // Set the status message in the session and redirect
    $_SESSION['statusMessage'] = 'Request submitted and is pending approval.';
    header('Location: transfer_request.php');
    exit;
}

// Check for status message in the session
if (isset($_SESSION['statusMessage'])) {
    $statusMessage = htmlspecialchars($_SESSION['statusMessage']);
    unset($_SESSION['statusMessage']);
}
ob_end_flush(); // Flush the output buffer
?>

<div class="container mt-4 content-container">
    <h2>Transfer Request</h2>
    <?php if ($statusMessage): ?>
        <div class="alert alert-info">
            <?php echo $statusMessage; ?>
        </div>
    <?php endif; ?>

    <?php if ($approvedTransfer && $formerDetails): ?>
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h3>Former Organisation</h3>
                        <p><strong>Name:</strong> <?php echo htmlspecialchars($formerDetails['organisation_name']); ?></p>
                        <p><strong>Location:</strong> <?php echo htmlspecialchars($formerDetails['location']); ?></p>
                        <p><strong>GPS Location:</strong> <a href="<?php echo htmlspecialchars($formerDetails['gps_location']); ?>"><?php echo htmlspecialchars($formerDetails['gps_location']); ?></a></p>
                        <p><strong>District:</strong> <?php echo htmlspecialchars($formerDetails['district']); ?></p>
                        <p><strong>Region:</strong> <?php echo htmlspecialchars($formerDetails['region']); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h3>Current Organisation</h3>
                        <p><strong>Name:</strong> <?php echo htmlspecialchars($approvedTransfer['new_organisation_name']); ?></p>
                        <p><strong>Location:</strong> <?php echo htmlspecialchars($approvedTransfer['new_location']); ?></p>
                        <p><strong>GPS Location:</strong> <a href="<?php echo htmlspecialchars($approvedTransfer['new_gps_location']); ?>"><?php echo htmlspecialchars($approvedTransfer['new_gps_location']); ?></a></p>
                        <p><strong>District:</strong> <?php echo htmlspecialchars($approvedTransfer['new_district']); ?></p>
                        <p><strong>Region:</strong> <?php echo htmlspecialchars($approvedTransfer['new_region']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <?php if ($currentDetails): ?>
                            <h3>Current Organisation</h3>
                            <p><strong>Name:</strong> <?php echo htmlspecialchars($currentDetails['organisation_name']); ?></p>
                            <p><strong>Location:</strong> <?php echo htmlspecialchars($currentDetails['location']); ?></p>
                            <p><strong>GPS Location:</strong> <a href="<?php echo htmlspecialchars($currentDetails['gps_location']); ?>"><?php echo htmlspecialchars($currentDetails['gps_location']); ?></a></p>
                            <p><strong>District:</strong> <?php echo htmlspecialchars($currentDetails['district']); ?></p>
                            <p><strong>Region:</strong> <?php echo htmlspecialchars($currentDetails['region']); ?></p>
                            <hr>
                        <?php endif; ?>
                        <form method="POST" action="transfer_request.php" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="newOrganisationName" class="form-label">New Organisation Name</label>
                                <input type="text" class="form-control" id="newOrganisationName" name="newOrganisationName" required>
                            </div>
                            <div class="mb-3">
                                <label for="newLocation" class="form-label">New Location</label>
                                <input type="text" class="form-control" id="newLocation" name="newLocation" required>
                            </div>
                            <div class="mb-3">
                                <label for="newGpsLocation" class="form-label">New Ghana Post GPS/Google Location</label>
                                <input type="text" class="form-control" id="newGpsLocation" name="newGpsLocation" required>
                            </div>
                            <div class="mb-3">
                                <label for="newRegion" class="form-label">New Region</label>
                                <select class="form-control" id="newRegion" name="newRegion" required>
                                    <option value="">Select Region</option>
                                    <?php foreach ($regions as $region): ?>
                                        <option value="<?php echo htmlspecialchars($region['region']); ?>"><?php echo htmlspecialchars($region['region']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="newDistrict" class="form-label">New District</label>
                                <select class="form-control" id="newDistrict" name="newDistrict" required>
                                    <option value="">Select District</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="reason" class="form-label">Reason for Transfer</label>
                                <textarea class="form-control" id="reason" name="reason" required></textarea>
                            </div>
                            <div class="mb-3">
                                <label for="acceptanceLetter" class="form-label">Upload Acceptance Letter</label>
                                <input type="file" class="form-control" id="acceptanceLetter" name="acceptanceLetter" required>
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane"></i> Submit Transfer Request
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Fetch districts based on the selected region
        document.getElementById('newRegion').addEventListener('change', function () {
            const region = this.value;
            const districtSelect = document.getElementById('newDistrict');
            districtSelect.innerHTML = '<option value="">Select District</option>';
            if (region) {
                fetch('fetch_districts.php?region=' + encodeURIComponent(region))
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Network response was not ok');
                        }
                        return response.json();
                    })
                    .then(data => {
                        districtSelect.innerHTML = '<option value="">Select District</option>'; // Clear previous options
                        data.forEach(district => {
                            const option = document.createElement('option');
                            option.value = district.district;
                            option.textContent = district.district;
                            districtSelect.appendChild(option);
                        });
                    })
                    .catch(error => console.error('Error fetching districts:', error));
            }
        });
    });
</script>

<?php include '../includes/footer.php'; ?>
