<?php
include '../includes/header.php';
?>

<div class="container mt-5 content-container d-flex justify-content-center">
    <div class="card w-100" style="max-width: 600px;">
        <div class="card-header">
            <h2>Register</h2>
        </div>
        <div class="card-body">
            <?php if (isset($_GET['error'])): ?>
                <div class="alert alert-danger">
                    <?php
                    if ($_GET['error'] === 'index_not_found') {
                        echo "Index number cannot be found.";
                    } elseif ($_GET['error'] === 'password_mismatch') {
                        echo "Passwords do not match.";
                    } elseif ($_GET['error'] === 'index_exists') {
                        echo "Index number already exists.";
                    }
                    ?>
                </div>
            <?php endif; ?>
            <form method="POST" action="register_action">
                <div class="mb-3">
                    <label for="indexNumber" class="form-label">Index Number</label>
                    <input type="text" class="form-control" id="indexNumber" name="indexNumber" required>
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <div class="input-group">
                        <input type="password" class="form-control" id="password" name="password" required>
                        <span class="input-group-text" id="togglePassword">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="confirmPassword" class="form-label">Confirm Password</label>
                    <div class="input-group">
                        <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" required>
                        <span class="input-group-text" id="toggleConfirmPassword">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="group" class="form-label">Internship Group</label>
                    <select class="form-control" id="group" name="group" required>
                        <option value="" disabled selected>Select your internship group</option>
                        <option value="Industrial Internship">Industrial Internship</option>
                        <option value="Teaching Practice">Teaching Practice</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="securityQuestion" class="form-label">Security Question</label>
                    <select class="form-control" id="securityQuestion" name="securityQuestion" required>
                        <option value="" disabled selected>Select a question</option>
                        <option value="What is the name of your favorite lecturer?">What is the name of your favorite lecturer?</option>
                        <option value="What is your favorite subject?">What is your favorite subject?</option>
                        <option value="What was your first hostel?">What was your first hostel?</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="securityAnswer" class="form-label">Answer</label>
                    <input type="text" class="form-control" id="securityAnswer" name="securityAnswer" required>
                </div>
                <button type="submit" class="btn btn-primary" style="border-radius: 0px;">
                    <i class="fas fa-user-plus"></i> Register
                </button>
            </form>
            <div class="mt-3">
                <p>Already have an account? <a href="login">Click here to login</a>.</p>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

<script>
    document.getElementById('togglePassword').addEventListener('click', function () {
        const passwordField = document.getElementById('password');
        const icon = this.querySelector('i');
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordField.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    });

    document.getElementById('toggleConfirmPassword').addEventListener('click', function () {
        const passwordField = document.getElementById('confirmPassword');
        const icon = this.querySelector('i');
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordField.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    });
</script>
