<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Internship Management System - Registration Closed</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0; 
      padding: 0;
      background-color: #f4f4f4;
    }
    .container {
      max-width: 600px;
      margin: 50px auto;
      padding: 20px;
      background: #fff;
      border-radius: 6px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h1 {
      text-align: center;
      margin-bottom: 20px;
    }
    p {
      font-size: 1.1rem;
      line-height: 1.6;
      margin-bottom: 1em;
    }
    .note {
      margin-top: 20px;
      padding: 10px;
      background-color: #ffe6e6;
      border-left: 4px solid #ff4d4d;
      font-style: italic;
    }
    .footer {
      text-align: center;
      font-size: 0.9rem;
      color: #555;
      margin-top: 30px;
    }
  </style>
</head>
<body>
  <div class="container">
    <h1>Registration Closed</h1>
    <p>
      Thank you for your interest in this semester’s internship program. 
      The student registration period is now closed, and all supervisors have been allocated.
    </p>
    <p>
      Please <strong>log in</strong> to the Internship Management System regularly to monitor 
      <strong>post-internship announcements</strong> and updates regarding any remaining tasks. 
      All information about the internship deadlines and requirements will be shared through the portal.
    </p>
    <div class="note">
      <strong>Important:</strong> We will be working with <strong>strict deadlines</strong>.
      <strong>Missing any deadline</strong> will result in a <strong>loss of grades</strong>. 
      Make sure to stay updated on all announcements and complete your tasks on time.
    </div>
    <div class="footer">
      &copy; 2025 Internship Management System
    </div>
  </div>
</body>
</html>
