<?php
ob_start(); // Start output buffering
include '../includes/header.php';

$statusMessage = '';
$securityQuestion = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['indexNumber'])) {
    include '../config/database.php';
    $indexNumber = htmlspecialchars($_POST['indexNumber'], ENT_QUOTES, 'UTF-8');

    // Fetch the security question for the provided index number
    $stmt = $pdo->prepare('SELECT security_question FROM users WHERE index_number = ?');
    $stmt->execute([$indexNumber]);
    $user = $stmt->fetch();

    if ($user) {
        $securityQuestion = $user['security_question'];
    } else {
        $statusMessage = 'Index number not found.';
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['securityAnswer'])) {
    include '../config/database.php';
    $indexNumber = htmlspecialchars($_POST['indexNumber'], ENT_QUOTES, 'UTF-8');
    $securityAnswer = htmlspecialchars($_POST['securityAnswer'], ENT_QUOTES, 'UTF-8');

    // Verify security answer
    $stmt = $pdo->prepare('SELECT id, security_question, security_answer FROM users WHERE index_number = ?');
    $stmt->execute([$indexNumber]);
    $user = $stmt->fetch();

    if ($user && $securityAnswer === $user['security_answer']) {
        // Generate reset token
        $token = bin2hex(random_bytes(16));
        $stmt = $pdo->prepare('INSERT INTO password_resets (user_id, token) VALUES (?, ?)');
        $stmt->execute([$user['id'], $token]);

        // Redirect to reset password page
        header("Location: reset_password?token=$token");
        exit;
    } else {
        $statusMessage = 'Incorrect index number or security answer.';
    }
}
?>

<!-- HTML Content -->
<div class="container d-flex justify-content-center align-items-center" style="min-height: 100vh;">
    <div class="card p-4" style="width: 100%; max-width: 400px;">
        <h2 class="card-title text-center">Forgot Password</h2>
        <?php if ($statusMessage): ?>
            <div class="alert alert-danger">
                <?php echo htmlspecialchars($statusMessage, ENT_QUOTES, 'UTF-8'); ?>
            </div>
        <?php endif; ?>

        <!-- Form for Index Number -->
        <form method="POST" action="forgot_password">
            <div class="mb-3">
                <label for="indexNumber" class="form-label">Index Number</label>
                <input type="text" class="form-control" id="indexNumber" name="indexNumber" 
                    value="<?php echo isset($indexNumber) ? htmlspecialchars($indexNumber, ENT_QUOTES, 'UTF-8') : ''; ?>" required>
                <button type="submit" class="btn btn-primary mt-2">Get Security Question</button>
            </div>

            <?php if (!empty($securityQuestion)): ?>
                <!-- Display Security Question -->
                <div class="mb-3">
                    <label class="form-label">Security Question</label>
                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($securityQuestion, ENT_QUOTES, 'UTF-8'); ?>" disabled>
                </div>
                <!-- Security Answer Input -->
                <div class="mb-3">
                    <label for="securityAnswer" class="form-label">Security Answer</label>
                    <input type="text" class="form-control" id="securityAnswer" name="securityAnswer" required>
                </div>
                <button type="submit" class="btn btn-primary w-100">Submit</button>
            <?php endif; ?>
        </form>
    </div>
</div>

<?php 
include '../includes/footer.php'; 
ob_end_flush(); // End output buffering and flush output
?>
