<?php
session_start();

require '../vendor/autoload.php';

use setasign\Fpdi\Fpdi;
use Smalot\PdfParser\Parser;

// Function to generate a random 20 alphanumeric code avoiding 'i' and 'o' and ensuring uppercase
function generateRandomCode($length = 20) {
    $characters = '123456789ABCDEFGHJKLMNPQRSTUVWXYZ';
    $rawCode = substr(str_shuffle(str_repeat($characters, ceil($length / strlen($characters)))), 1, $length);
    return strtoupper(implode('-', str_split($rawCode, 5)));
}

// Function to get or create a unique code for a user
function getUserUniqueCode($userId, $pdo) {
    // Check if the user already has a unique code in the database
    $stmt = $pdo->prepare('SELECT unique_code FROM users WHERE id = ?');
    $stmt->execute([$userId]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row && !empty($row['unique_code'])) {
        return htmlspecialchars($row['unique_code'], ENT_QUOTES, 'UTF-8');
    } else {
        // Generate a new unique code for the user
        $uniqueCode = generateRandomCode();
        $stmt = $pdo->prepare('UPDATE users SET unique_code = ? WHERE id = ?');
        $stmt->execute([$uniqueCode, $userId]);
        return htmlspecialchars($uniqueCode, ENT_QUOTES, 'UTF-8');
    }
}

// Database connection
include '../config/database.php';

// Assume a user ID is available, e.g., from a login system
$userId = $_SESSION['user_id']; // Replace this with actual user ID or username
$indexNumber = htmlspecialchars($_SESSION['index_number'], ENT_QUOTES, 'UTF-8'); // Fetch and sanitize the index number from the session

// Get or create the unique code for the user
$uniqueCode = getUserUniqueCode($userId, $pdo);

// Fetch the user's group from the database
$stmt = $pdo->prepare('SELECT `group` FROM users WHERE id = ?');
$stmt->execute([$userId]);
$userGroup = htmlspecialchars($stmt->fetchColumn(), ENT_QUOTES, 'UTF-8');

// Path to the PDF document based on the user's group
if ($userGroup === 'Industrial Internship') {
    $pdfPath = '../document.pdf';
} else if ($userGroup === 'Teaching Practice') {
    $pdfPath = '../document1.pdf';
} else {
    // Handle unexpected group value (optional)
    die('Invalid user group.');
}

// Create a new FPDI instance
$pdf = new Fpdi();
$pageCount = $pdf->setSourceFile($pdfPath);

// Create a new PDF parser instance
$parser = new Parser();
$document = $parser->parseFile($pdfPath);
$pages = $document->getPages();

for ($pageNo = 1; $pageNo <= $pageCount; $pageNo++) {
    $tplId = $pdf->importPage($pageNo);
    // Check the user's group to determine the page orientation
    if ($userGroup === 'Teaching Practice') {
        $pdf->AddPage('L'); // Landscape orientation
    } else {
        $pdf->AddPage('P'); // Portrait orientation
    }
    $pdf->useTemplate($tplId, 0, 0);

    // Check if the page has content
    $pageText = $pages[$pageNo - 1]->getText();
    if (trim($pageText) !== '') {
        // Add the unique code at the top of each page with content
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetXY(10, 10);
        $pdf->Cell(0, 10, $uniqueCode, 0, 0, 'C');
    }
}

// Set headers to download the PDF with the index number in the filename
$fileName = $indexNumber . '_eval_form.pdf';
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="' . htmlspecialchars($fileName, ENT_QUOTES, 'UTF-8') . '"');
$pdf->Output('D', $fileName);

exit;
?>
