<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

include '../includes/header.php';
include '../config/database.php';

// Optional: If you still want to use a real deadline check, do it here
// $deadline = '2025-03-12 23:59:59';
// $deadlinePassed = (time() > strtotime($deadline));

$statusMessage = '';
if (isset($_GET['status'])) {
    if ($_GET['status'] === 'submitted') {
        $statusMessage = 'Your details have been submitted.';
    } elseif ($_GET['status'] === 'saved') {
        $statusMessage = 'Your details have been saved. You can continue later.';
    } elseif ($_GET['status'] === 'error_upload') {
        $statusMessage = 'There was an error uploading your file. Please try again.';
    } elseif ($_GET['status'] === 'invalid_file_type') {
        $statusMessage = 'Invalid file type. Only PDF and image files (JPG, PNG) are allowed.';
    }
}

// Fetch the logged-in user's group and existing details if any
$userId = $_SESSION['user_id'];
$stmt = $pdo->prepare('
    SELECT `group`, 
           (SELECT status FROM student_details WHERE user_id = ?) AS submission_status 
    FROM users 
    WHERE id = ?
');
$stmt->execute([$userId, $userId]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

$group            = htmlspecialchars($user['group'], ENT_QUOTES, 'UTF-8');
$submissionStatus = htmlspecialchars($user['submission_status'], ENT_QUOTES, 'UTF-8');

$isSubmitted = ($submissionStatus === 'submitted');
$isSaved     = ($submissionStatus === 'saved');

$lecturerName = '';
if ($isSaved || $isSubmitted) {
    $stmt = $pdo->prepare('SELECT * FROM student_details WHERE user_id = ?');
    $stmt->execute([$userId]);
    $studentDetails = $stmt->fetch(PDO::FETCH_ASSOC) ?: [];

    if (!empty($studentDetails['lecturer_id'])) {
        $stmt = $pdo->prepare('SELECT name FROM lecturer_login WHERE id = ?');
        $stmt->execute([$studentDetails['lecturer_id']]);
        $lecturer = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($lecturer) {
            $lecturerName = htmlspecialchars($lecturer['name'], ENT_QUOTES, 'UTF-8');
        }
    }
} else {
    // Default/empty fields if user has never saved or submitted
    $studentDetails = [
        'surname'           => '',
        'first_name'        => '',
        'other_names'       => '',
        'telephone'         => '',
        'email'             => '',
        'course'            => '',
        'organisation_name' => '',
        'months'            => '',
        'location'          => '',
        'gps_location'      => '',
        'region'            => '',
        'district'          => '',
        'acceptance_letter' => ''
    ];
}
?>

<style>
  .btn-custom {
      background-color: #007bff;
      color: white !important;
      border: none;
      border-radius: 0;
      padding: 10px 20px;
      text-align: center;
      text-decoration: none;
      display: inline-block;
      font-size: 16px;
      margin: 4px 2px;
      cursor: pointer;
      box-shadow: 0 2px 4px rgba(0,0,0,0.2);
      transition: background-color 0.3s, box-shadow 0.3s;
  }
  .btn-custom:hover {
      background-color: #0056b3;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
  }
  .spinner {
      display: none;
      margin-left: 10px;
      width: 20px;
      height: 20px;
      border: 3px solid #f3f3f3;
      border-top: 3px solid #007bff;
      border-radius: 50%;
      animation: spin 1s linear infinite;
  }
  @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
  }
  .swipe-button-container {
      margin-top: 20px;
  }
  /* Make the swipe button look "disabled" */
  #swipeButtonDisabled {
      background-color: #cccccc; /* a gray color */
      color: #666666;            /* darker gray text */
      padding: 15px 30px;
      font-size: 18px;
      border-radius: 0;
      display: inline-block;
      user-select: none;
      cursor: not-allowed;
      touch-action: none;
      opacity: 0.7;
  }
  /* Just a placeholder arrow icon for consistency */
  #swipeButtonDisabled i {
      margin-left: 10px;
  }
  .supervisor-name {
      margin-top: 15px;
      text-align: center;
      font-size: 18px;
      color: #007bff;
      font-weight: bold;
  }
  @media (max-width: 576px) {
      .supervisor-name {
          font-size: 16px;
      }
  }
  @media (max-width: 480px) {
      h2, h4 {
          font-size: 1.5rem;
      }
      .btn-custom {
          font-size: 14px;
          padding: 8px 16px;
      }
      #swipeButtonDisabled {
          font-size: 16px;
          padding: 10px 20px;
      }
  }
</style>

<div class="container mt-4">
  <?php if (!empty($statusMessage)): ?>
      <div class="alert alert-info" id="statusMessage">
          <?php echo htmlspecialchars($statusMessage, ENT_QUOTES, 'UTF-8'); ?>
      </div>
  <?php endif; ?>

  <form method="POST" action="save_student_details.php" enctype="multipart/form-data" id="studentForm">
    <div class="row justify-content-center">
      <div class="col-md-8 col-lg-6">
          <h2>University of Education, Winneba</h2>
          <h4>School of Business.</h4>

          <?php if ($isSubmitted): ?>
              <!-- Download Card (User has already submitted acceptance letter) -->
              <div class="card mb-4">
                  <div class="card-header">
                      <h3>Download Supervisor's Evaluation Form</h3>
                  </div>
                  <div class="card-body text-center">
                      <a href="download_evaluation.php" class="btn btn-custom">
                          <i class="fas fa-download"></i> Download
                      </a>
                  </div>
              </div>

              <!-- DEACTIVATED "Swipe" button, replaced with a disabled style -->
              <div class="swipe-button-container text-center">
                  <div id="swipeButtonDisabled">
                      Swipe to Post-Internship Report <i class="fas fa-arrow-right"></i>
                  </div>
              </div>

              <!-- Supervisor Name if available -->
              <?php if (!empty($lecturerName)): ?>
                  <div class="supervisor-name">
                      Supervisor: <?php echo $lecturerName; ?>
                  </div>
              <?php endif; ?>

          <?php else: ?>
              <!-- If NOT submitted, show message or form (depending on your logic).
                   Here, we assume submission is closed, so we display "Submission Closed." -->
              <div class="card mb-4">
                  <div class="card-header">
                      <h3>Submission Closed</h3>
                  </div>
                  <div class="card-body">
                      <p class="text-danger">
                          Submission of acceptance letters is now closed. 
                          You can no longer submit your acceptance form.
                      </p>
                  </div>
              </div>
          <?php endif; ?>

      </div>
    </div>
  </form>
</div>

<!-- No event listener for the swipe button since it's deactivated -->

<?php include '../includes/footer.php'; ?>
