<?php
session_start();
include '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize and validate input
    $name = htmlspecialchars($_POST['name'], ENT_QUOTES, 'UTF-8');
    $contact = htmlspecialchars($_POST['contact'], ENT_QUOTES, 'UTF-8');
    $department = htmlspecialchars($_POST['department'], ENT_QUOTES, 'UTF-8');
    $staffId = htmlspecialchars($_POST['staff_id'], ENT_QUOTES, 'UTF-8');
    $carNumber = htmlspecialchars($_POST['car_number'], ENT_QUOTES, 'UTF-8');
    $username = htmlspecialchars($_POST['username'], ENT_QUOTES, 'UTF-8');
    $password = $_POST['password'];
    $confirmPassword = $_POST['confirmPassword'];

    // Validate passwords match
    if ($password !== $confirmPassword) {
        header('Location: signup?error=password_mismatch');
        exit;
    }

    // Validate staff ID exists in the valid_staff_id table
    try {
        $stmt = $pdo->prepare("SELECT 1 FROM valid_staff_id WHERE staff_id = ?");
        $stmt->execute([$staffId]);
        if ($stmt->rowCount() === 0) {
            header('Location: signup?error=invalid_staff_id');
            exit;
        }
    } catch (PDOException $e) {
        header('Location: signup?error=database_error');
        exit;
    }

    // Ensure the staff ID is not already registered in the lecturer_login table
    try {
        $stmt = $pdo->prepare("SELECT 1 FROM lecturer_login WHERE staff_id = ?");
        $stmt->execute([$staffId]);
        if ($stmt->rowCount() > 0) {
            header('Location: signup?error=staff_id_already_registered');
            exit;
        }
    } catch (PDOException $e) {
        header('Location: signup?error=database_error');
        exit;
    }

    // Hash the password
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    // Insert the new lecturer into the database
    try {
        $stmt = $pdo->prepare("INSERT INTO lecturer_login (name, contact, department, staff_id, car_number, username, password) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$name, $contact, $department, $staffId, $carNumber, $username, $hashedPassword]);
    } catch (PDOException $e) {
        header('Location: signup?error=registration_error');
        exit;
    }

    // Redirect to login page after successful signup
    header('Location: login?success=registered');
    exit;
}
?>
