<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['lecturer_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php';

$lecturerId = $_SESSION['lecturer_id'];
$action = $_POST['action']; // 'save' or 'submit'
$status = $action === 'submit' ? 'submitted' : 'saved';
$marks = $_POST['marks']; // Array of marks from the form
$studentIds = $_POST['student_ids']; // Array of student IDs from the form

try {
    $pdo->beginTransaction();
    
    // Loop through each student and save or update their results
    foreach ($studentIds as $index => $studentId) {
        $mark = $marks[$index];

        // Calculate grade, GP, and description based on marks
        if ($mark >= 80 && $mark <= 100) {
            $grade = 'A'; $gp = 4.0; $description = 'Excellent';
        } elseif ($mark >= 75 && $mark <= 79) {
            $grade = 'B+'; $gp = 3.5; $description = 'Very Good';
        } elseif ($mark >= 70 && $mark <= 74) {
            $grade = 'B'; $gp = 3.0; $description = 'Good';
        } elseif ($mark >= 65 && $mark <= 69) {
            $grade = 'C+'; $gp = 2.5; $description = 'Average';
        } elseif ($mark >= 60 && $mark <= 64) {
            $grade = 'C'; $gp = 2.0; $description = 'Fair';
        } elseif ($mark >= 55 && $mark <= 59) {
            $grade = 'D+'; $gp = 1.5; $description = 'Barely Satisfactory';
        } elseif ($mark >= 50 && $mark <= 54) {
            $grade = 'D'; $gp = 1.0; $description = 'Weak Pass';
        } elseif ($mark >= 0 && $mark <= 49) {
            $grade = 'E'; $gp = 0.0; $description = 'Fail';
        } else {
            $grade = ''; $gp = ''; $description = '';
        }

        // Check if the result already exists for the student
        $stmt = $pdo->prepare('SELECT COUNT(*) FROM student_results WHERE student_id = ? AND lecturer_id = ?');
        $stmt->execute([$studentId, $lecturerId]);
        if ($stmt->fetchColumn() > 0) {
            // Update the existing result
            $stmt = $pdo->prepare('
                UPDATE student_results SET 
                    marks = ?, grade = ?, gp = ?, description = ?, status = ? 
                WHERE student_id = ? AND lecturer_id = ?
            ');
            $stmt->execute([$mark, $grade, $gp, $description, $status, $studentId, $lecturerId]);
        } else {
            // Insert a new result
            $stmt = $pdo->prepare('
                INSERT INTO student_results (student_id, index_number, marks, grade, gp, description, status, lecturer_id) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?)
            ');
            $stmt->execute([$studentId, $_POST['index_numbers'][$index], $mark, $grade, $gp, $description, $status, $lecturerId]);
        }
    }

    $pdo->commit();

    header('Location: results.php');
    exit;
} catch (Exception $e) {
    $pdo->rollBack();
    echo 'Failed to save results: ' . $e->getMessage();
}
?>
