<?php
session_start();
include '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Normalize input: Remove spaces, dashes, and convert to uppercase
    $car_number = strtoupper(preg_replace('/\s|-/', '', $_POST['car_number']));

    // Fetch all car numbers from the database
    $stmt = $pdo->prepare('SELECT id, car_number, contact FROM lecturer_login');
    $stmt->execute();
    $users = $stmt->fetchAll();

    $user_found = null;

    // Compare the normalized car numbers
    foreach ($users as $user) {
        $normalized_db_car_number = strtoupper(preg_replace('/\s|-/', '', $user['car_number']));
        if ($normalized_db_car_number === $car_number) {
            $user_found = $user;
            break;
        }
    }

    if ($user_found) {
        $contact = $user_found['contact'];
        $last_two_digits = substr($contact, -2); // Get the last two digits

        if (strlen($last_two_digits) === 2) {
            $first_digit = (int)$last_two_digits[0];
            $second_digit = (int)$last_two_digits[1];
            $correct_answer = $first_digit * $second_digit;
        } else {
            $correct_answer = 0; // If only one digit exists, multiply by 0
        }

        $_SESSION['reset_user_id'] = $user_found['id'];
        $_SESSION['correct_answer'] = $correct_answer;
        header("Location: reset_password.php");
        exit;
    } else {
        $error = "Car number not found.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Forgot Password</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="d-flex justify-content-center align-items-center bg-light vh-100">
    <div class="card shadow-lg p-4 rounded-3" style="max-width: 400px; width: 100%;">
        <h2 class="card-title text-center mb-3">Forgot Password</h2>
        <?php if (isset($error)): ?>
            <div class="alert alert-danger text-center"><?php echo $error; ?></div>
        <?php endif; ?>
        <form method="POST" action="" autocomplete="off">
            <div class="mb-3">
                <label for="car_number" class="form-label fw-bold">Enter Your Car Number</label>
                <input type="text" class="form-control" id="car_number" name="car_number" required 
                    placeholder="Enter car number (e.g., GG909921)" oninput="validateCarNumber()">
                <small class="text-muted">Remove spaces and dashes (e.g., GG909921).</small>
            </div>
            <button type="submit" class="btn btn-primary w-100">Proceed</button>
        </form>
        <div class="mt-3 text-center">
            <a href="login.php" class="text-decoration-none">Back to Login</a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function validateCarNumber() {
            const input = document.getElementById('car_number');
            input.value = input.value.replace(/\s|-/g, '').toUpperCase(); // Remove spaces/dashes and convert to uppercase
        }
    </script>
</body>
</html>
